import { Button } from "@/components/ui/button"
import { Card, CardContent, CardHeader, CardTitle } from "@/components/ui/card"
import { Shield, Phone, AlertTriangle, Users, Heart, FileText } from "lucide-react"
import Link from "next/link"

export default function ChildProtectionPage() {
  return (
    <div className="container mx-auto px-4 py-12 md:py-24">
      <div className="text-center mb-12">
        <h1 className="text-4xl font-bold mb-6 text-vazoOrange">Child Protection & Safeguarding</h1>
        <p className="text-lg text-gray-700 max-w-3xl mx-auto">
          At Vazo Foundations, we are committed to building a child-safe community in Pelican Park and surrounding
          areas. We work to prevent, detect, and address violence against children while providing comprehensive support
          services.
        </p>
      </div>

      {/* Emergency Contact Section */}
      <section className="mb-12 bg-red-50 border-l-4 border-red-500 p-6 rounded-lg">
        <div className="flex items-center mb-4">
          <AlertTriangle className="h-8 w-8 text-red-500 mr-3" />
          <h2 className="text-2xl font-bold text-red-700">Emergency Contacts</h2>
        </div>
        <div className="grid grid-cols-1 md:grid-cols-2 gap-4">
          <div>
            <h3 className="font-semibold text-red-700 mb-2">Immediate Danger</h3>
            <p className="text-red-600">
              Police Emergency:{" "}
              <a href="tel:10111" className="font-bold hover:underline">
                10111
              </a>
            </p>
            <p className="text-red-600">
              Ambulance:{" "}
              <a href="tel:10177" className="font-bold hover:underline">
                10177
              </a>
            </p>
          </div>
          <div>
            <h3 className="font-semibold text-red-700 mb-2">Child Protection</h3>
            <p className="text-red-600">
              Childline:{" "}
              <a href="tel:08000055555" className="font-bold hover:underline">
                0800 005 5555
              </a>
            </p>
            <p className="text-red-600">
              DSD Child Protection:{" "}
              <a href="tel:0800220250" className="font-bold hover:underline">
                0800 220 250
              </a>
            </p>
          </div>
        </div>
      </section>

      {/* Our Services */}
      <section className="mb-12">
        <h2 className="text-3xl font-bold text-center mb-8 text-gray-800">Our Child Protection Services</h2>
        <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
          <Card className="p-6 text-center">
            <Shield className="h-12 w-12 text-vazoOrange mb-4 mx-auto" />
            <CardTitle className="text-xl font-bold mb-3">Child-Friendly Reporting</CardTitle>
            <CardContent className="p-0">
              <p className="text-gray-700">
                Safe, confidential ways for children and community members to report concerns about child safety and
                wellbeing.
              </p>
            </CardContent>
          </Card>

          <Card className="p-6 text-center">
            <Heart className="h-12 w-12 text-vazoOrange mb-4 mx-auto" />
            <CardTitle className="text-xl font-bold mb-3">First-Line Support</CardTitle>
            <CardContent className="p-0">
              <p className="text-gray-700">
                Immediate emotional support and practical assistance for children and families affected by violence or
                abuse.
              </p>
            </CardContent>
          </Card>

          <Card className="p-6 text-center">
            <Users className="h-12 w-12 text-vazoOrange mb-4 mx-auto" />
            <CardTitle className="text-xl font-bold mb-3">Family Strengthening</CardTitle>
            <CardContent className="p-0">
              <p className="text-gray-700">
                Programs and support services designed to strengthen families and prevent child abuse and neglect.
              </p>
            </CardContent>
          </Card>

          <Card className="p-6 text-center">
            <FileText className="h-12 w-12 text-vazoOrange mb-4 mx-auto" />
            <CardTitle className="text-xl font-bold mb-3">Case Management</CardTitle>
            <CardContent className="p-0">
              <p className="text-gray-700">
                Coordinated referrals and case management with partner NGOs and designated DSD practitioners.
              </p>
            </CardContent>
          </Card>

          <Card className="p-6 text-center">
            <Phone className="h-12 w-12 text-vazoOrange mb-4 mx-auto" />
            <CardTitle className="text-xl font-bold mb-3">24/7 Support Line</CardTitle>
            <CardContent className="p-0">
              <p className="text-gray-700">
                Round-the-clock support and crisis intervention for children and families in need of immediate
                assistance.
              </p>
            </CardContent>
          </Card>

          <Card className="p-6 text-center">
            <Shield className="h-12 w-12 text-vazoOrange mb-4 mx-auto" />
            <CardTitle className="text-xl font-bold mb-3">Community Safety</CardTitle>
            <CardContent className="p-0">
              <p className="text-gray-700">
                Community-wide initiatives to create safer environments for children through our Vigulate program.
              </p>
            </CardContent>
          </Card>
        </div>
      </section>

      {/* How to Report */}
      <section className="mb-12 bg-gray-50 p-8 rounded-lg">
        <h2 className="text-3xl font-bold text-center mb-8 text-gray-800">How to Report a Concern</h2>
        <div className="grid grid-cols-1 md:grid-cols-2 gap-8">
          <div>
            <h3 className="text-xl font-bold mb-4 text-vazoOrange">Multiple Ways to Report</h3>
            <ul className="space-y-3 text-gray-700">
              <li className="flex items-start">
                <Phone className="h-5 w-5 text-vazoOrange mr-2 mt-0.5" />
                <span>
                  <strong>Phone:</strong> Call our confidential helpline at{" "}
                  <a href="tel:+27123456789" className="text-vazoOrange hover:underline">
                    +27 12 345 6789
                  </a>
                </span>
              </li>
              <li className="flex items-start">
                <Shield className="h-5 w-5 text-vazoOrange mr-2 mt-0.5" />
                <span>
                  <strong>Vigulate App:</strong> Use our community safety app for anonymous reporting
                </span>
              </li>
              <li className="flex items-start">
                <Users className="h-5 w-5 text-vazoOrange mr-2 mt-0.5" />
                <span>
                  <strong>In Person:</strong> Visit our office at 10a Flamingo Way, Pelican Park
                </span>
              </li>
              <li className="flex items-start">
                <FileText className="h-5 w-5 text-vazoOrange mr-2 mt-0.5" />
                <span>
                  <strong>Online:</strong> Submit a confidential report through our website
                </span>
              </li>
              <li className="flex items-start mt-4">
                <Button asChild className="bg-red-600 hover:bg-red-700 text-white">
                  <Link href="/report-incident">
                    <AlertTriangle className="h-4 w-4 mr-2" />
                    Submit Anonymous Report
                  </Link>
                </Button>
              </li>
            </ul>
          </div>
          <div>
            <h3 className="text-xl font-bold mb-4 text-vazoOrange">What Happens Next?</h3>
            <ol className="space-y-3 text-gray-700 list-decimal list-inside">
              <li>Your report is received and logged confidentially</li>
              <li>We assess the level of risk and urgency</li>
              <li>Immediate safety measures are put in place if needed</li>
              <li>We coordinate with appropriate authorities and partners</li>
              <li>Follow-up support is provided to the child and family</li>
              <li>Regular monitoring ensures ongoing safety</li>
            </ol>
          </div>
        </div>
      </section>

      {/* Vigulate Program */}
      <section className="mb-12">
        <div className="bg-vazoOrange text-white p-8 rounded-lg text-center">
          <h2 className="text-3xl font-bold mb-4">Vigulate Community Safety Program</h2>
          <p className="text-lg mb-6">
            Our innovative community safety enablement program uses technology to enhance child protection through:
          </p>
          <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-4 text-sm">
            <div className="bg-white/10 p-4 rounded">
              <h4 className="font-bold mb-2">Incident Reporting</h4>
              <p>Anonymous, secure reporting system</p>
            </div>
            <div className="bg-white/10 p-4 rounded">
              <h4 className="font-bold mb-2">Community Alerts</h4>
              <p>Real-time safety notifications</p>
            </div>
            <div className="bg-white/10 p-4 rounded">
              <h4 className="font-bold mb-2">Safe Route Mapping</h4>
              <p>Identify and promote safe pathways</p>
            </div>
            <div className="bg-white/10 p-4 rounded">
              <h4 className="font-bold mb-2">Volunteer Coordination</h4>
              <p>Organize community safety volunteers</p>
            </div>
          </div>
          <div className="mt-6">
            <Button asChild variant="secondary" size="lg">
              <Link href="/programs/vigulate">Learn More About Vigulate</Link>
            </Button>
          </div>
        </div>
      </section>

      {/* Support for Families */}
      <section className="mb-12">
        <h2 className="text-3xl font-bold text-center mb-8 text-gray-800">Support for Families</h2>
        <div className="grid grid-cols-1 md:grid-cols-2 gap-8">
          <Card className="p-6">
            <CardHeader className="p-0 mb-4">
              <CardTitle className="text-xl font-bold text-vazoOrange">Caregiver Workshops</CardTitle>
            </CardHeader>
            <CardContent className="p-0">
              <p className="text-gray-700 mb-4">
                Educational workshops for parents and caregivers covering child development, positive parenting, and
                creating safe home environments.
              </p>
              <ul className="text-sm text-gray-600 space-y-1">
                <li>• Positive discipline techniques</li>
                <li>• Recognizing signs of trauma</li>
                <li>• Building resilient families</li>
                <li>• Accessing community resources</li>
              </ul>
            </CardContent>
          </Card>

          <Card className="p-6">
            <CardHeader className="p-0 mb-4">
              <CardTitle className="text-xl font-bold text-vazoOrange">Relief Support</CardTitle>
            </CardHeader>
            <CardContent className="p-0">
              <p className="text-gray-700 mb-4">
                Practical assistance for families in crisis, including emergency support and connections to essential
                services.
              </p>
              <ul className="text-sm text-gray-600 space-y-1">
                <li>• Emergency food and clothing</li>
                <li>• Temporary accommodation assistance</li>
                <li>• Healthcare referrals</li>
                <li>• Legal support connections</li>
              </ul>
            </CardContent>
          </Card>
        </div>
        <div className="text-center mt-8">
          <Button asChild size="lg" className="bg-green-600 hover:bg-green-700 text-white mr-4">
            <Link href="/parent-support">Request Parent Support</Link>
          </Button>
          <Button asChild variant="secondary" size="lg">
            <Link href="/programs/vigulate">Learn More About Vigulate</Link>
          </Button>
        </div>
      </section>

      {/* Partner Organizations */}
      <section className="mb-12 bg-gray-50 p-8 rounded-lg">
        <h2 className="text-3xl font-bold text-center mb-8 text-gray-800">Our Partners in Child Protection</h2>
        <p className="text-center text-gray-700 mb-8 max-w-3xl mx-auto">
          We work closely with established organizations to ensure comprehensive support for children and families:
        </p>
        <div className="grid grid-cols-1 md:grid-cols-3 gap-6">
          <div className="text-center">
            <h4 className="font-bold text-vazoOrange mb-2">Government Partners</h4>
            <ul className="text-sm text-gray-600 space-y-1">
              <li>Department of Social Development</li>
              <li>South African Police Service</li>
              <li>Department of Health</li>
              <li>Department of Education</li>
            </ul>
          </div>
          <div className="text-center">
            <h4 className="font-bold text-vazoOrange mb-2">NGO Partners</h4>
            <ul className="text-sm text-gray-600 space-y-1">
              <li>Childline South Africa</li>
              <li>Local Child Protection Organizations</li>
              <li>Community-Based Organizations</li>
              <li>Faith-Based Organizations</li>
            </ul>
          </div>
          <div className="text-center">
            <h4 className="font-bold text-vazoOrange mb-2">Healthcare Partners</h4>
            <ul className="text-sm text-gray-600 space-y-1">
              <li>Local Clinics and Hospitals</li>
              <li>Mental Health Services</li>
              <li>Trauma Counseling Centers</li>
              <li>Community Health Workers</li>
            </ul>
          </div>
        </div>
      </section>

      {/* Call to Action */}
      <section className="text-center">
        <h2 className="text-3xl font-bold mb-6 text-gray-800">Get Involved in Child Protection</h2>
        <p className="text-lg text-gray-700 mb-8 max-w-3xl mx-auto">
          Everyone has a role to play in keeping children safe. Whether you want to volunteer, report a concern, or
          learn more about child protection, we're here to help.
        </p>
        <div className="flex flex-col sm:flex-row gap-4 justify-center">
          <Button asChild size="lg" className="bg-vazoOrange hover:bg-vazoOrange/90 text-white">
            <Link href="/get-involved/volunteer">Become a Volunteer</Link>
          </Button>
          <Button
            asChild
            variant="outline"
            size="lg"
            className="border-vazoOrange text-vazoOrange hover:bg-vazoOrange/10 bg-transparent"
          >
            <Link href="mailto:safeguarding@vazofoundations.org">Contact Our Team</Link>
          </Button>
        </div>
      </section>

      {/* Legal Notice */}
      <section className="mt-12 p-6 bg-blue-50 border-l-4 border-blue-500 rounded-lg">
        <h3 className="font-bold text-blue-700 mb-2">Important Legal Information</h3>
        <p className="text-sm text-blue-600">
          All child protection activities are conducted in compliance with the Children's Act 38 of 2005, the Protection
          of Personal Information Act (POPIA), and other relevant South African legislation. We maintain strict
          confidentiality while ensuring the safety and wellbeing of children.
        </p>
      </section>
    </div>
  )
}
