import { Card, CardContent, CardDescription, CardHeader, CardTitle } from "@/components/ui/card"
import { Button } from "@/components/ui/button"
import { Badge } from "@/components/ui/badge"
import { Mail, Phone, MessageCircle, Instagram, Linkedin, Users, Heart, Target, ArrowLeft } from "lucide-react"
import Link from "next/link"

export default function DirectorsPage() {
  return (
    <div className="min-h-screen bg-gradient-to-br from-blue-50 to-indigo-100">
      <div className="container mx-auto px-4 py-8">
        {/* Back Navigation */}
        <div className="mb-6">
          <Link href="/about">
            <Button variant="outline" className="gap-2 bg-transparent">
              <ArrowLeft className="h-4 w-4" />
              Back to About
            </Button>
          </Link>
        </div>

        {/* Header Section */}
        <div className="text-center mb-12">
          <div className="flex items-center justify-center gap-2 mb-4">
            <Users className="h-8 w-8 text-blue-600" />
            <h1 className="text-4xl font-bold text-gray-900">Meet the Directors</h1>
          </div>
          <p className="text-xl text-gray-600 max-w-3xl mx-auto">
            Our leadership team brings together expertise in programs, partnerships, and digital systems to drive
            positive change in our communities.
          </p>
        </div>

        {/* Shared Responsibilities */}
        <Card className="mb-12">
          <CardHeader>
            <CardTitle className="flex items-center gap-2">
              <Heart className="h-5 w-5 text-red-500" />
              Shared Leadership Responsibilities
            </CardTitle>
            <CardDescription>Our directors work collaboratively across key areas of the organization</CardDescription>
          </CardHeader>
          <CardContent>
            <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
              <div className="space-y-3">
                <div className="flex items-center gap-2">
                  <Users className="h-5 w-5 text-blue-500" />
                  <h3 className="font-semibold">Human Resources</h3>
                </div>
                <p className="text-sm text-gray-600">
                  Joint responsibility for recruitment, performance management, and creating a positive work environment.
                </p>
              </div>

              <div className="space-y-3">
                <div className="flex items-center gap-2">
                  <Target className="h-5 w-5 text-green-500" />
                  <h3 className="font-semibold">Strategic Planning</h3>
                </div>
                <p className="text-sm text-gray-600">
                  Collaborative planning to set goals, develop strategies, and ensure alignment with our mission and
                  vision.
                </p>
              </div>

              <div className="space-y-3">
                <div className="flex items-center gap-2">
                  <Heart className="h-5 w-5 text-purple-500" />
                  <h3 className="font-semibold">Community Engagement</h3>
                </div>
                <p className="text-sm text-gray-600">
                  Coordinated relationship-building with community members, partners, and stakeholders to maximize
                  impact.
                </p>
              </div>
            </div>
          </CardContent>
        </Card>

        {/* Directors Grid */}
        <div className="grid grid-cols-1 lg:grid-cols-3 gap-8 mb-12">
          {/* Darren Davids */}
          <Card className="hover:shadow-lg transition-shadow duration-300">
            <CardHeader className="text-center">
              <div className="w-32 h-32 bg-gradient-to-br from-emerald-500 to-emerald-600 rounded-full mx-auto mb-4 flex items-center justify-center">
                <span className="text-white text-3xl font-bold">DD</span>
              </div>
              <CardTitle className="text-xl">Darren Davids</CardTitle>
              <CardDescription className="text-lg font-semibold text-emerald-600">
                Director of Programs &amp; Organisational Compliance
              </CardDescription>
            </CardHeader>
            <CardContent className="space-y-4">
              <div className="space-y-2">
                <Badge className="bg-green-100 text-green-800">Program Management</Badge>
                <Badge className="bg-blue-100 text-blue-800">Compliance &amp; Operations</Badge>
                <Badge className="bg-red-100 text-red-800">Safeguarding</Badge>
              </div>

              <p className="text-gray-600 text-sm leading-relaxed">
                A social entrepreneur and community builder, Darren focuses on creating sustainable, high-impact
                programs.
              </p>

              <div className="space-y-3 pt-4 border-t">
                <h4 className="font-semibold text-gray-800">Key Responsibilities:</h4>
                <ul className="text-sm text-gray-600 space-y-1">
                  <li>• Designs, manages, and executes youth, digital literacy, and job-readiness programs.</li>
                  <li>• Oversees compliance, procurement, and efficient administrative operations.</li>
                  <li>• Leads community engagement, mentorship, and safeguarding through Vigilant.</li>
                </ul>
              </div>
            </CardContent>
          </Card>

          {/* Tyrone Damon */}
          <Card className="hover:shadow-lg transition-shadow duration-300">
            <CardHeader className="text-center">
              <div className="w-32 h-32 bg-gradient-to-br from-blue-500 to-blue-600 rounded-full mx-auto mb-4 flex items-center justify-center">
                <span className="text-white text-3xl font-bold">TD</span>
              </div>
              <CardTitle className="text-xl">Tyrone Damon</CardTitle>
              <CardDescription className="text-lg font-semibold text-blue-600">
                Director of Partnerships &amp; Strategic Alliances
              </CardDescription>
            </CardHeader>
            <CardContent className="space-y-4">
              <div className="space-y-2">
                <Badge className="bg-blue-100 text-blue-800">Strategic Partnerships</Badge>
                <Badge className="bg-green-100 text-green-800">Stakeholder Engagement</Badge>
                <Badge className="bg-yellow-100 text-yellow-800">Growth &amp; Funding</Badge>
              </div>

              <p className="text-gray-600 text-sm leading-relaxed">
                With a background in sales, marketing, and relationship management, Tyrone is dedicated to fostering
                collaboration for social good.
              </p>

              <div className="space-y-3 pt-4 border-t">
                <h4 className="font-semibold text-gray-800">Key Responsibilities:</h4>
                <ul className="text-sm text-gray-600 space-y-1">
                  <li>• Leads partnerships and strategic collaborations to advance impact.</li>
                  <li>• Builds and maintains relationships with key sector stakeholders.</li>
                  <li>• Develops and executes strategies to unlock program support,
                    funding opportunities, and brand collaborations that drive both sustainability and innovation</li>
                </ul>
              </div>
            </CardContent>
          </Card>

          {/* Sebastian Hendricks */}
          <Card className="hover:shadow-lg transition-shadow duration-300">
            <CardHeader className="text-center">
              <div className="w-32 h-32 bg-gradient-to-br from-purple-500 to-purple-600 rounded-full mx-auto mb-4 flex items-center justify-center">
                <span className="text-white text-3xl font-bold">SH</span>
              </div>
              <CardTitle className="text-xl">Sebastian Hendricks</CardTitle>
              <CardDescription className="text-lg font-semibold text-purple-600">
                Director of Digital Strategy &amp; Systems
              </CardDescription>
            </CardHeader>
            <CardContent className="space-y-4">
              <div className="space-y-2">
                <Badge className="bg-purple-100 text-purple-800">Digital Strategy</Badge>
                <Badge className="bg-blue-100 text-blue-800">Data &amp; Analytics</Badge>
                <Badge className="bg-gray-100 text-gray-800">Security &amp; Compliance</Badge>
              </div>

              <p className="text-gray-600 text-sm leading-relaxed">
                A technologist and data engineer, Sebastian is enthusiastic about using technology to drive social change
                and empower communities.
              </p>

              <div className="space-y-3 pt-4 border-t">
                <h4 className="font-semibold text-gray-800">Key Responsibilities:</h4>
                <ul className="text-sm text-gray-600 space-y-1">
                  <li>• Drives innovation through digital systems, data architecture, and automation.</li>
                  <li>• Leads analytics and reporting via dashboards to measure program impact.</li>
                  <li>• Oversees Vigilant and Vazo Link platforms, ensuring security and compliance.</li>
                </ul>
              </div>
            </CardContent>
          </Card>
        </div>

        {/* Contact Section */}
        <Card className="text-center">
          <CardHeader>
            <CardTitle>Get in Touch with Our Leadership Team</CardTitle>
            <CardDescription>
              Have questions or want to connect with our directors? We'd love to hear from you.
            </CardDescription>
          </CardHeader>
          <CardContent className="space-y-4">
            <div className="flex flex-wrap justify-center gap-4">
              <Button className="gap-2">
                <Mail className="h-4 w-4" />
                Email Leadership Team
              </Button>
              <Button variant="outline" className="gap-2 bg-transparent">
                <Phone className="h-4 w-4" />
                Schedule a Meeting
              </Button>
            </div>
            <p className="text-sm text-gray-500">
              General inquiries: info@vasofoundations.org | Phone: +27 (0) 123 456 789
            </p>
          </CardContent>
        </Card>
      </div>
    </div>
  )
}
