import Image from "next/image"

export default function GalleryPage() {
  const albums = [
    {
      title: "Skills Workshops in Action",
      description: "Moments from our weekly coding and digital literacy bootcamps.",
      images: [
        { src: "/placeholder.svg?height=300&width=400", alt: "Youth coding workshop" },
        { src: "/placeholder.svg?height=300&width=400", alt: "Digital literacy class" },
        { src: "/placeholder.svg?height=300&width=400", alt: "Students learning computers" },
      ],
    },
    {
      title: "Mentorship Circles",
      description: "Connecting young people with experienced industry experts.",
      images: [
        { src: "/placeholder.svg?height=300&width=400", alt: "Mentorship group discussion" },
        { src: "/placeholder.svg?height=300&width=400", alt: "Mentor advising mentee" },
        { src: "/placeholder.svg?height=300&width=400", alt: "Career guidance session" },
      ],
    },
    {
      title: "Job-Readiness Coaching",
      description: "Preparing our graduates for the job market.",
      images: [
        { src: "/placeholder.svg?height=300&width=400", alt: "Mock interview session" },
        { src: "/placeholder.svg?height=300&width=400", alt: "CV building workshop" },
        { src: "/placeholder.svg?height=300&width=400", alt: "Job fair networking" },
      ],
    },
    {
      title: "Community Outreach",
      description: "Engaging with the community and making a difference.",
      images: [
        { src: "/placeholder.svg?height=300&width=400", alt: "Community event" },
        { src: "/placeholder.svg?height=300&width=400", alt: "VAZO Foundation outreach" },
        { src: "/placeholder.svg?height=300&width=400", alt: "Volunteers helping community" },
      ],
    },
  ]

  return (
    <div className="container mx-auto px-4 py-12 md:py-24">
      <h1 className="text-4xl font-bold mb-6 text-center text-vazoOrange">Our Gallery</h1>
      <p className="text-lg text-gray-700 text-center max-w-3xl mx-auto mb-12">
        Explore moments from our programs, events, and community engagement.
      </p>

      <div className="grid grid-cols-1 md:grid-cols-2 gap-12">
        {albums.map((album, index) => (
          <div key={index} className="space-y-6 bg-gray-50 dark:bg-gray-800 p-6 rounded-lg shadow-md">
            <h2 className="text-3xl font-bold text-gray-800 text-center">{album.title}</h2>
            <p className="text-gray-700 text-center">{album.description}</p>
            <div className="grid grid-cols-1 sm:grid-cols-2 gap-4">
              {album.images.map((image, imgIndex) => (
                <div key={imgIndex} className="relative w-full h-48 overflow-hidden rounded-lg">
                  <Image
                    src={image.src || "/placeholder.svg"}
                    alt={image.alt}
                    layout="fill"
                    objectFit="cover"
                    className="transition-transform duration-300 hover:scale-105"
                    loading="lazy"
                  />
                </div>
              ))}
            </div>
            {/* Optional: Add a "View More" link for each album if there were more images */}
            {/* <div className="text-center mt-4">
              <Link href="#" className="text-vazoOrange hover:underline font-medium">
                View All {album.title} &rarr;
              </Link>
            </div> */}
          </div>
        ))}
      </div>
    </div>
  )
}
