import { Button } from "@/components/ui/button"
import { Card, CardContent, CardDescription, CardHeader, CardTitle } from "@/components/ui/card"
import { Badge } from "@/components/ui/badge"
import { Shield, BookOpen, Briefcase, Home, Activity, Target, ArrowRight } from "lucide-react"
import Link from "next/link"
import Image from "next/image"

export default function OurStoryPage() {
  return (
    <div className="min-h-screen">
      {/* Hero Section */}
      <section className="relative bg-gradient-to-br from-blue-600 via-blue-700 to-indigo-800 text-white py-20 overflow-hidden">
        <div className="absolute inset-0 bg-black/20"></div>
        <div className="absolute inset-0 bg-[url('/community-empowerment-background.jpg')] bg-cover bg-center opacity-10"></div>

        <div className="container mx-auto px-4 relative z-10">
          <div className="max-w-4xl mx-auto text-center">
            <div className="flex justify-center mb-6">
              <Image
                src="/vazo-foundation-logo.png"
                alt="VAZO Foundation Logo"
                width={120}
                height={120}
                className="rounded-full bg-white/10 p-4"
              />
            </div>

            <Badge className="mb-6 bg-white/20 text-white border-white/30 hover:bg-white/30">Founded in 2025</Badge>

            <h1 className="text-4xl md:text-6xl font-bold mb-6 leading-tight">
              Our Story
              <span className="block text-yellow-300">Building Hope Together</span>
            </h1>

            <p className="text-xl md:text-2xl mb-8 text-blue-100 max-w-3xl mx-auto">
              Every great idea deserves a chance to grow—and every child deserves a safe place to dream.
            </p>
          </div>
        </div>
      </section>

      {/* Our Story Content */}
      <section className="py-16 bg-gray-50">
        <div className="container mx-auto px-4">
          <div className="max-w-4xl mx-auto">
            <div className="prose prose-lg max-w-none">
              <p className="text-xl text-gray-700 leading-relaxed mb-8">
                Vazo Foundations was born from a simple belief: every great idea deserves a chance to grow—and every
                child deserves a safe place to dream.
              </p>

              <p className="text-lg text-gray-600 leading-relaxed mb-8">
                In Pelican Park and the surrounding areas, we saw a need not only for opportunities but also for
                protection, hope, and guidance. Too many young people face violence, limited resources, and uncertain
                futures. Our story began as a response to this reality: to create a community where safety, learning,
                and opportunity go hand in hand.
              </p>

              <p className="text-lg text-gray-600 leading-relaxed mb-12">
                We are more than an organization—we are a movement. A movement that empowers startups, nurtures young
                talent, and builds bridges between dreams and dignity.
              </p>

              <div className="bg-white p-8 rounded-lg shadow-lg mb-12">
                <p className="text-lg text-gray-600 leading-relaxed mb-6">
                  Founded in 2025 by three community-driven individuals committed to driving positive change, VAZO
                  FOUNDATION NPC empowers Cape Town's youth. We operate with integrity, prioritizing empowerment and
                  community collaboration.
                </p>
                <p className="text-lg text-gray-600 leading-relaxed">
                  VAZO FOUNDATION NPC is a registered Non-Profit Company (Registration No 2025 / 634473 / 08). We're
                  currently in the process of applying for Section 18A status to make your future donations
                  tax-deductible.
                </p>
              </div>
            </div>
          </div>
        </div>
      </section>

      {/* Our Objectives */}
      <section className="py-16">
        <div className="container mx-auto px-4">
          <div className="text-center mb-12">
            <h2 className="text-3xl md:text-4xl font-bold mb-4 text-gray-800">Our Objectives</h2>
            <p className="text-xl text-gray-600 max-w-2xl mx-auto">
              Clear goals that guide our mission to build safer, stronger communities.
            </p>
          </div>

          {/* Primary Objective */}
          <div className="max-w-4xl mx-auto mb-16">
            <Card className="border-l-4 border-l-green-500 bg-green-50">
              <CardHeader>
                <div className="flex items-center space-x-3">
                  <div className="bg-green-100 p-3 rounded-full">
                    <Target className="h-8 w-8 text-green-600" />
                  </div>
                  <div>
                    <CardTitle className="text-2xl text-green-800">4.1 Primary Objective</CardTitle>
                    <CardDescription className="text-green-700">Our core mission and purpose</CardDescription>
                  </div>
                </div>
              </CardHeader>
              <CardContent>
                <p className="text-lg text-green-800 leading-relaxed">
                  To build a child-safe community in Pelican Park and surrounding areas by preventing, detecting, and
                  addressing violence against children, while equipping youth with academic support, mentoring, life
                  skills, and clear pathways to dignified work and entrepreneurship.
                </p>
              </CardContent>
            </Card>
          </div>

          {/* Supporting Objectives */}
          <div className="max-w-6xl mx-auto">
            <h3 className="text-2xl font-bold mb-8 text-center text-gray-800">4.2 Supporting Objectives</h3>
            <div className="grid md:grid-cols-2 lg:grid-cols-3 gap-8">
              {/* Learning & Skills Development */}
              <Card className="border-t-4 border-t-blue-500 hover:shadow-lg transition-shadow">
                <CardHeader>
                  <div className="mx-auto bg-blue-100 w-16 h-16 rounded-full flex items-center justify-center mb-4">
                    <BookOpen className="h-8 w-8 text-blue-600" />
                  </div>
                  <CardTitle className="text-blue-800 text-center">Learning & Skills Development</CardTitle>
                </CardHeader>
                <CardContent>
                  <p className="text-gray-600 text-center">
                    Partnering with after-school tutoring NPOs, digital literacy programmes, and CV/Interview clinics
                    that include workplace rights and safeguarding basics.
                  </p>
                </CardContent>
              </Card>

              {/* Child Protection & Social Welfare */}
              <Card className="border-t-4 border-t-red-500 hover:shadow-lg transition-shadow">
                <CardHeader>
                  <div className="mx-auto bg-red-100 w-16 h-16 rounded-full flex items-center justify-center mb-4">
                    <Shield className="h-8 w-8 text-red-600" />
                  </div>
                  <CardTitle className="text-red-800 text-center">Child Protection & Social Welfare</CardTitle>
                </CardHeader>
                <CardContent>
                  <p className="text-gray-600 text-center">
                    Providing child-friendly reporting and first-line support for child-based violence (CBV);
                    coordinating referrals and case management with partner NGOs and designated DSD practitioners.
                  </p>
                </CardContent>
              </Card>

              {/* Health & Wellness */}
              <Card className="border-t-4 border-t-purple-500 hover:shadow-lg transition-shadow">
                <CardHeader>
                  <div className="mx-auto bg-purple-100 w-16 h-16 rounded-full flex items-center justify-center mb-4">
                    <Activity className="h-8 w-8 text-purple-600" />
                  </div>
                  <CardTitle className="text-purple-800 text-center">Health & Wellness</CardTitle>
                </CardHeader>
                <CardContent>
                  <p className="text-gray-600 text-center">
                    Promoting sport and recreation for pro-social engagement; offering trauma-informed mental-health
                    screening and referral pathways via partners; running caregiver workshops.
                  </p>
                </CardContent>
              </Card>

              {/* Community Safety Enablement (Vigilant) */}
              <Card className="border-t-4 border-t-orange-500 hover:shadow-lg transition-shadow">
                <CardHeader>
                  <div className="mx-auto bg-orange-100 w-16 h-16 rounded-full flex items-center justify-center mb-4">
                    <Home className="h-8 w-8 text-orange-600" />
                  </div>
                  <CardTitle className="text-orange-800 text-center">Community Safety Enablement (Vigilant)</CardTitle>
                </CardHeader>
                <CardContent>
                  <p className="text-gray-600 text-center">
                    Implementing the Vigilant programme and app for CBV incident reporting, community alerts, volunteer
                    scheduling, safe-route mapping, and venue safety protocols.
                  </p>
                </CardContent>
              </Card>

              {/* Opportunity Matching (Vazo Link) */}
              <Card className="border-t-4 border-t-teal-500 hover:shadow-lg transition-shadow md:col-span-2 lg:col-span-1">
                <CardHeader>
                  <div className="mx-auto bg-teal-100 w-16 h-16 rounded-full flex items-center justify-center mb-4">
                    <Briefcase className="h-8 w-8 text-teal-600" />
                  </div>
                  <CardTitle className="text-teal-800 text-center">Opportunity Matching (Vazo Link)</CardTitle>
                </CardHeader>
                <CardContent>
                  <p className="text-gray-600 text-center">
                    Launching the Vazo Link programme and app to connect youth to mentors, services, gigs, internships,
                    and community opportunities—prioritising vulnerable/at-risk youth.
                  </p>
                </CardContent>
              </Card>
            </div>
          </div>
        </div>
      </section>

      {/* Call to Action */}
      <section className="py-16 bg-gradient-to-r from-green-600 to-blue-600 text-white">
        <div className="container mx-auto px-4">
          <div className="max-w-4xl mx-auto text-center">
            <h2 className="text-3xl md:text-4xl font-bold mb-6">Join Our Story</h2>
            <p className="text-xl mb-8 text-green-100">
              Be part of the movement that's building safer, stronger communities in Pelican Park and beyond.
            </p>

            <div className="flex flex-col sm:flex-row gap-4 justify-center">
              <Button asChild size="lg" variant="secondary" className="bg-white text-blue-700 hover:bg-gray-100">
                <Link href="/get-involved">
                  Get Involved
                  <ArrowRight className="ml-2 h-5 w-5" />
                </Link>
              </Button>
              <Button
                asChild
                size="lg"
                variant="outline"
                className="border-white text-white hover:bg-white/10 bg-transparent"
              >
                <Link href="/programs">
                  Explore Programs
                  <ArrowRight className="ml-2 h-5 w-5" />
                </Link>
              </Button>
            </div>
          </div>
        </div>
      </section>
    </div>
  )
}
