import Link from "next/link"
import { Button } from "@/components/ui/button"
import { Card, CardContent, CardDescription, CardHeader, CardTitle } from "@/components/ui/card"
import { Heart, Users, Target, Award, TrendingUp, Eye, ShieldCheck } from "lucide-react"

export default function AboutPage() {
  return (
    <div className="min-h-screen bg-gradient-to-br from-orange-50 to-blue-50">
      <div className="container mx-auto px-4 py-12">
        {/* Hero Section */}
        <div className="text-center mb-12">
          <h1 className="text-4xl md:text-5xl font-bold text-gray-900 mb-6">About VAZO Foundation</h1>
          <p className="text-xl text-gray-600 max-w-3xl mx-auto leading-relaxed">
            Empowering communities through child safety, education, and opportunity. Building a brighter future for South
            African youth and families.
          </p>
        </div>

        {/* Mission & Vision Cards */}
        <div className="grid md:grid-cols-2 gap-8 mb-12">
          <Card className="border-2 border-vazoOrange">
            <CardHeader>
              <CardTitle className="flex items-center gap-2 text-2xl">
                <Target className="h-8 w-8 text-vazoOrange" />
                Our Mission
              </CardTitle>
            </CardHeader>
            <CardContent>
              <p className="text-gray-700 leading-relaxed">
                To create safer, more connected communities by empowering youth through technology, education,
                mentorship, and child protection initiatives. We bridge the gap between potential and opportunity while
                preventing, detecting, and responding to violence against children—helping young South Africans build
                sustainable and secure futures.
              </p>
            </CardContent>
          </Card>

          <Card className="border-2 border-blue-600">
            <CardHeader>
              <CardTitle className="flex items-center gap-2 text-2xl">
                <Eye className="h-8 w-8 text-blue-600" />
                Our Vision
              </CardTitle>
            </CardHeader>
            <CardContent>
              <p className="text-gray-700 leading-relaxed">
                A South Africa where every young person has access to safety, quality education, and economic
                opportunities—enabled by strong partnerships. Where communities thrive through collaboration,
                partnerships, innovation, and shared prosperity.
              </p>
            </CardContent>
          </Card>
        </div>

        {/* Core Values */}
        <Card className="mb-12">
          <CardHeader>
            <CardTitle className="text-2xl text-center">Our Core Values</CardTitle>
            <CardDescription className="text-center">The principles that guide everything we do</CardDescription>
          </CardHeader>
          <CardContent>
            <div className="grid md:grid-cols-3 gap-8">
              <div className="text-center">
                <div className="bg-vazoOrange/10 w-16 h-16 rounded-full flex items-center justify-center mx-auto mb-4">
                  <Heart className="h-8 w-8 text-vazoOrange" />
                </div>
                <h3 className="font-bold text-lg mb-2">Community First</h3>
                <p className="text-gray-600 text-sm">
                  We put the needs of our communities at the heart of everything we do, fostering connections and
                  support networks.
                </p>
              </div>

              <div className="text-center">
                <div className="bg-blue-600/10 w-16 h-16 rounded-full flex items-center justify-center mx-auto mb-4">
                  <Users className="h-8 w-8 text-blue-600" />
                </div>
                <h3 className="font-bold text-lg mb-2">Empowerment</h3>
                <p className="text-gray-600 text-sm">
                  We believe in giving people the tools, knowledge, and opportunities to transform their own lives and
                  communities.
                </p>
              </div>

              <div className="text-center">
                <div className="bg-green-600/10 w-16 h-16 rounded-full flex items-center justify-center mx-auto mb-4">
                  <TrendingUp className="h-8 w-8 text-green-600" />
                </div>
                <h3 className="font-bold text-lg mb-2">Innovation</h3>
                <p className="text-gray-600 text-sm">
                  We embrace technology and creative solutions to tackle social challenges—from child safety and
                  safeguarding to education access, opportunity matching, and mentorship.
                </p>
              </div>

              <div className="text-center">
                <div className="bg-purple-600/10 w-16 h-16 rounded-full flex items-center justify-center mx-auto mb-4">
                  <Target className="h-8 w-8 text-purple-600" />
                </div>
                <h3 className="font-bold text-lg mb-2">Integrity</h3>
                <p className="text-gray-600 text-sm">
                  We operate with transparency, accountability, and ethical practices, with a deep commitment to child
                  safeguarding and data privacy across all programs and partnerships.
                </p>
              </div>

              <div className="text-center">
                <div className="bg-rose-600/10 w-16 h-16 rounded-full flex items-center justify-center mx-auto mb-4">
                  <ShieldCheck className="h-8 w-8 text-rose-600" />
                </div>
                <h3 className="font-bold text-lg mb-2">Safety &amp; Accountability</h3>
                <p className="text-gray-600 text-sm">
                  We uphold the highest standards of child protection and responsible data practices, with clear
                  protocols, oversight, and continuous improvement.
                </p>
              </div>

              <div className="text-center">
                <div className="bg-orange-600/10 w-16 h-16 rounded-full flex items-center justify-center mx-auto mb-4">
                  <Award className="h-8 w-8 text-orange-600" />
                </div>
                <h3 className="font-bold text-lg mb-2">Excellence</h3>
                <p className="text-gray-600 text-sm">
                  We strive for the highest standards in program delivery, maintaining quality and measurable impact.
                </p>
              </div>

              <div className="text-center">
                <div className="bg-pink-600/10 w-16 h-16 rounded-full flex items-center justify-center mx-auto mb-4">
                  <Heart className="h-8 w-8 text-pink-600" />
                </div>
                <h3 className="font-bold text-lg mb-2">Compassion</h3>
                <p className="text-gray-600 text-sm">
                  We approach every individual and situation with empathy, understanding, and genuine care for their
                  wellbeing.
                </p>
              </div>
            </div>
          </CardContent>
        </Card>

        {/* Impact Stats */}
        <div className="grid md:grid-cols-4 gap-6 mb-12">
          <Card className="text-center bg-gradient-to-br from-vazoOrange to-orange-600 text-white">
            <CardContent className="pt-6">
              <div className="text-4xl font-bold mb-2">1000+</div>
              <p className="text-white/90">Youth Empowered</p>
            </CardContent>
          </Card>
          <Card className="text-center bg-gradient-to-br from-blue-600 to-blue-700 text-white">
            <CardContent className="pt-6">
              <div className="text-4xl font-bold mb-2">50+</div>
              <p className="text-white/90">Partner Organizations</p>
            </CardContent>
          </Card>
          <Card className="text-center bg-gradient-to-br from-green-600 to-green-700 text-white">
            <CardContent className="pt-6">
              <div className="text-4xl font-bold mb-2">25+</div>
              <p className="text-white/90">Active Programs</p>
            </CardContent>
          </Card>
          <Card className="text-center bg-gradient-to-br from-purple-600 to-purple-700 text-white">
            <CardContent className="pt-6">
              <div className="text-4xl font-bold mb-2">10K+</div>
              <p className="text-white/90">Community Members Reached</p>
            </CardContent>
          </Card>
        </div>

        {/* Call to Action */}
        <Card className="bg-gradient-to-br from-vazoOrange to-orange-600 text-white">
          <CardContent className="p-8 text-center">
            <h2 className="text-3xl font-bold mb-4">Join Our Mission</h2>
            <p className="text-lg mb-6 text-white/90 max-w-2xl mx-auto">
              Whether through volunteering, partnership, or support, there are many ways to get involved and make a
              difference in your community.
            </p>
            <div className="flex flex-col sm:flex-row gap-4 justify-center">
              <Button asChild size="lg" variant="secondary">
                <Link href="/get-involved/volunteer">Become a Volunteer</Link>
              </Button>
              <Button
                asChild
                size="lg"
                variant="outline"
                className="bg-white/10 border-white hover:bg-white/20 text-white"
              >
                <Link href="/get-involved/partner">Partner With Us</Link>
              </Button>
              <Button
                asChild
                size="lg"
                variant="outline"
                className="bg-white/10 border-white hover:bg-white/20 text-white"
              >
                <Link href="/about/directors">Meet Our Directors</Link>
              </Button>
            </div>
          </CardContent>
        </Card>
      </div>
    </div>
  )
}
