"use server"

import { sendEmail, formatFormDataAsHTML } from "@/lib/email"

export async function submitParentSupportRequest(formData: FormData) {
  try {
    const data = {
      "Form Type": "Parent Support Request",
      "Parent/Guardian Name": formData.get("parentName") as string,
      Email: formData.get("email") as string,
      Phone: formData.get("phone") as string,
      City: formData.get("city") as string,
      "Number of Children": formData.get("numberOfChildren") as string,
      "Children's Ages": formData.get("childrenAges") as string,
      "Support Type Needed": formData.get("supportType") as string,
      "Situation Description": formData.get("situation") as string,
      "Specific Concerns": formData.get("concerns") as string,
      "Previous Support Services": formData.get("previousSupport") as string,
      "Preferred Contact Method": formData.get("preferredContact") as string,
      "Urgency Level": formData.get("urgency") as string,
      "Privacy Consent": formData.get("privacyConsent") === "true" ? "Yes" : "No",
      "Submitted At": new Date().toLocaleString("en-ZA", { timeZone: "Africa/Johannesburg" }),
    }

    const emailBody = formatFormDataAsHTML(data)
    await sendEmail({
      subject: `New Parent Support Request - ${data["Parent/Guardian Name"]} (${data["Urgency Level"]} Priority)`,
      body: emailBody,
      replyTo: data.Email,
    })

    return {
      success: true,
      message: "Thank you for reaching out. Our family support team will contact you within 24-48 hours.",
    }
  } catch (error) {
    console.error("Parent support request error:", error)
    return {
      success: false,
      message: "There was an error submitting your request. Please try again or call us directly.",
    }
  }
}
