"use server"

import { sendEmail, formatFormDataAsHTML } from "@/lib/email"

export async function submitPartnerInquiry(formData: FormData) {
  try {
    const data = {
      "Form Type": "Partnership Inquiry",
      "Organization Name": formData.get("organizationName") as string,
      "Contact Person": formData.get("contactPerson") as string,
      Email: formData.get("email") as string,
      Phone: formData.get("phone") as string,
      "Organization Type": formData.get("organizationType") as string,
      "Partnership Interest": formData.get("partnershipType") as string,
      "Organization Description": formData.get("organizationDescription") as string,
      "Partnership Proposal": formData.get("proposal") as string,
      "Privacy Consent": formData.get("privacyConsent") === "true" ? "Yes" : "No",
      "Submitted At": new Date().toLocaleString("en-ZA", { timeZone: "Africa/Johannesburg" }),
    }

    const emailBody = formatFormDataAsHTML(data)
    await sendEmail({
      subject: `New Partnership Inquiry - ${data["Organization Name"]}`,
      body: emailBody,
      replyTo: data.Email,
    })

    return {
      success: true,
      message: "Thank you for your interest in partnering with us! We'll be in touch soon.",
    }
  } catch (error) {
    console.error("Partnership inquiry error:", error)
    return {
      success: false,
      message: "There was an error submitting your inquiry. Please try again.",
    }
  }
}
