"use server"

import { sendEmail, formatFormDataAsHTML } from "@/lib/email"

export async function subscribeToVigilant(_prevState: any, formData: FormData) {
  try {
    const email = formData.get("email") as string

    if (!email || !email.includes("@")) {
      return {
        success: false,
        message: "Please enter a valid email address.",
      }
    }

    const data = {
      "Form Type": "Vigilant Subscription",
      Email: email,
      "Subscribed At": new Date().toLocaleString("en-ZA", { timeZone: "Africa/Johannesburg" }),
    }

    const emailBody = formatFormDataAsHTML(data)
    await sendEmail({
      subject: "New Vigilant Subscription",
      body: emailBody,
      replyTo: email,
    })

    return {
      success: true,
      message: "Thank you for subscribing! We'll keep you updated on Vigilant's launch.",
    }
  } catch (error) {
    console.error("Subscription error:", error)
    return {
      success: false,
      message: "There was an error processing your subscription. Please try again.",
    }
  }
}

export async function joinVazoLinkWaitlist(_prevState: any, formData: FormData) {
  try {
    const email = formData.get("email") as string
    const subscriberType = formData.get("subscriberType") as string

    if (!email || !email.includes("@")) {
      return {
        success: false,
        message: "Please enter a valid email address.",
      }
    }

    const data = {
      "Form Type": "VAZO Link Waitlist",
      Email: email,
      "Subscriber Type": subscriberType || "Community Member",
      "Joined At": new Date().toLocaleString("en-ZA", { timeZone: "Africa/Johannesburg" }),
    }

    const emailBody = formatFormDataAsHTML(data)
    await sendEmail({
      subject: "New VAZO Link Waitlist Signup",
      body: emailBody,
      replyTo: email,
    })

    return {
      success: true,
      message: "Thank you for joining the waitlist! We'll notify you when VAZO Link launches.",
    }
  } catch (error) {
    console.error("Waitlist signup error:", error)
    return {
      success: false,
      message: "There was an error processing your signup. Please try again.",
    }
  }
}

export async function subscribeToProject(formData: FormData) {
  try {
    const projectName = formData.get("projectName") as string
    const email = formData.get("email") as string

    if (!email || !email.includes("@")) {
      return {
        success: false,
        message: "Please enter a valid email address.",
      }
    }

    const data = {
      "Form Type": `${projectName} Subscription`,
      Email: email,
      "Subscribed At": new Date().toLocaleString("en-ZA", { timeZone: "Africa/Johannesburg" }),
    }

    const emailBody = formatFormDataAsHTML(data)
    await sendEmail({
      subject: `New ${projectName} Subscription`,
      body: emailBody,
      replyTo: email,
    })

    return {
      success: true,
      message: `Thank you for subscribing to ${projectName}! We'll keep you updated.`,
    }
  } catch (error) {
    console.error("Subscription error:", error)
    return {
      success: false,
      message: "There was an error processing your subscription. Please try again.",
    }
  }
}
