import { Card, CardContent, CardHeader, CardTitle } from "@/components/ui/card"
import { Shield, Users, FileText, AlertTriangle, Lock, Eye, CheckCircle, Phone } from "lucide-react"
import Link from "next/link"

export default function DataProtectionPage() {
  return (
    <div className="container mx-auto px-4 py-12 md:py-24">
      <div className="text-center mb-12">
        <h1 className="text-4xl font-bold mb-6 text-vazoOrange">Data Protection Policy</h1>
        <p className="text-lg text-gray-700 max-w-3xl mx-auto">
          VAZO Foundation NPC's comprehensive framework for ensuring lawful, secure, and transparent processing of
          personal information in compliance with POPIA and PAIA.
        </p>
        <p className="text-sm text-gray-600 mt-4">Last Updated: January 2025</p>
      </div>

      {/* Quick Reference */}
      <section className="mb-12 bg-vazoOrange text-white p-6 rounded-lg">
        <div className="flex items-center mb-4">
          <Shield className="h-8 w-8 mr-3" />
          <h2 className="text-2xl font-bold">Information Officer Contact</h2>
        </div>
        <div className="grid grid-cols-1 md:grid-cols-2 gap-4">
          <div>
            <h3 className="font-semibold mb-2">Sebastian Hendricks</h3>
            <p className="text-sm">Director of Digital Strategy & Systems</p>
            <p className="text-sm">
              Email:{" "}
              <a href="mailto:privacy@vazofoundations.org" className="font-bold hover:underline">
                privacy@vazofoundations.org
              </a>
            </p>
            <p className="text-sm">
              Phone:{" "}
              <a href="tel:0878222686" className="font-bold hover:underline">
                0878222686
              </a>
            </p>
          </div>
          <div>
            <h3 className="font-semibold mb-2">Key Responsibilities</h3>
            <ul className="text-sm space-y-1">
              <li>• Overall accountability for POPIA and PAIA compliance</li>
              <li>• Ensuring data protection policies are implemented</li>
              <li>• Handling access to information requests</li>
              <li>• Reporting to the Information Regulator</li>
            </ul>
          </div>
        </div>
      </section>

      {/* 1. Purpose */}
      <section className="mb-12">
        <Card className="p-6">
          <CardHeader className="p-0 mb-6">
            <CardTitle className="text-2xl font-bold text-vazoOrange flex items-center">
              <FileText className="h-6 w-6 mr-2" />
              1. Purpose
            </CardTitle>
          </CardHeader>
          <CardContent className="p-0 space-y-4">
            <p className="text-gray-700">
              The purpose of this Data Protection Policy is to establish a comprehensive framework for ensuring the
              lawful, secure, and transparent processing of personal information in line with the Protection of Personal
              Information Act (POPIA) and the Promotion of Access to Information Act (PAIA).
            </p>
            <p className="text-gray-700">
              This policy ensures that VAZO Foundation NPC maintains the highest standards of data protection while
              fulfilling our mission of youth empowerment and child protection in Cape Town communities.
            </p>
            <div className="bg-blue-50 p-4 rounded-lg">
              <h4 className="font-semibold text-blue-700 mb-2">Policy Objectives:</h4>
              <ul className="text-sm text-blue-600 space-y-1">
                <li>• Ensure full compliance with POPIA and PAIA requirements</li>
                <li>• Protect the privacy rights of all data subjects</li>
                <li>• Establish clear accountability and governance structures</li>
                <li>• Minimize risks associated with data processing</li>
                <li>• Maintain transparency in our data handling practices</li>
              </ul>
            </div>
          </CardContent>
        </Card>
      </section>

      {/* 2. Scope */}
      <section className="mb-12">
        <Card className="p-6">
          <CardHeader className="p-0 mb-6">
            <CardTitle className="text-2xl font-bold text-vazoOrange flex items-center">
              <Users className="h-6 w-6 mr-2" />
              2. Scope
            </CardTitle>
          </CardHeader>
          <CardContent className="p-0 space-y-4">
            <p className="text-gray-700">
              This policy applies to all individuals and entities who process or have access to personal and business
              information collected, stored, or processed by VAZO Foundation NPC.
            </p>

            <div className="grid grid-cols-1 md:grid-cols-2 gap-6">
              <div className="bg-green-50 p-4 rounded-lg">
                <h4 className="font-semibold text-green-700 mb-3">Covered Personnel</h4>
                <ul className="text-sm text-green-600 space-y-1">
                  <li>• All directors and board members</li>
                  <li>• Full-time and part-time employees</li>
                  <li>• Volunteers and mentors</li>
                  <li>• Contractors and consultants</li>
                  <li>• Interns and temporary staff</li>
                  <li>• Partner organization representatives</li>
                </ul>
              </div>

              <div className="bg-blue-50 p-4 rounded-lg">
                <h4 className="font-semibold text-blue-700 mb-3">Data Categories Covered</h4>
                <ul className="text-sm text-blue-600 space-y-1">
                  <li>• Program participant information</li>
                  <li>• Volunteer and staff records</li>
                  <li>• Child protection case files</li>
                  <li>• Donor and partner data</li>
                  <li>• Website and digital platform data</li>
                  <li>• Financial and operational records</li>
                </ul>
              </div>
            </div>

            <div className="bg-gray-50 p-4 rounded-lg">
              <h4 className="font-semibold text-gray-800 mb-2">Geographic Scope:</h4>
              <p className="text-sm text-gray-600">
                This policy applies to all data processing activities conducted within South Africa and any cross-border
                data transfers involving VAZO Foundation NPC operations.
              </p>
            </div>
          </CardContent>
        </Card>
      </section>

      {/* 3. Responsibilities */}
      <section className="mb-12">
        <Card className="p-6">
          <CardHeader className="p-0 mb-6">
            <CardTitle className="text-2xl font-bold text-vazoOrange flex items-center">
              <CheckCircle className="h-6 w-6 mr-2" />
              3. Responsibilities
            </CardTitle>
          </CardHeader>
          <CardContent className="p-0 space-y-6">
            <div className="bg-vazoOrange text-white p-6 rounded-lg">
              <h4 className="font-semibold text-xl mb-4">Information Officer (IO)</h4>
              <div className="grid grid-cols-1 md:grid-cols-2 gap-4">
                <div>
                  <p className="font-semibold mb-2">Position: Director of Digital Strategy & Systems</p>
                  <p className="font-semibold mb-2">Current IO: Sebastian Hendricks</p>
                  <p className="text-sm mb-2">📧 privacy@vazofoundations.org | 📞 0878222686</p>
                </div>
                <div>
                  <h5 className="font-semibold mb-2">Key Responsibilities:</h5>
                  <ul className="text-sm space-y-1">
                    <li>• Overall accountability for POPIA and PAIA compliance</li>
                    <li>• Ensuring data protection policies are implemented and maintained</li>
                    <li>• Handling access to information requests</li>
                    <li>• Reporting to the Information Regulator as required</li>
                    <li>• Appointing and overseeing Deputy Information Officers</li>
                  </ul>
                </div>
              </div>
            </div>

            <div className="grid grid-cols-1 md:grid-cols-2 gap-6">
              <div className="bg-blue-50 p-4 rounded-lg">
                <h4 className="font-semibold text-blue-700 mb-3">Deputy Information Officers (DIOs)</h4>
                <ul className="text-sm text-blue-600 space-y-1">
                  <li>• Assist the IO in compliance activities</li>
                  <li>• Handle day-to-day data protection queries</li>
                  <li>• Conduct privacy impact assessments</li>
                  <li>• Monitor compliance within their departments</li>
                  <li>• Must be registered with the Information Regulator</li>
                </ul>
              </div>

              <div className="bg-green-50 p-4 rounded-lg">
                <h4 className="font-semibold text-green-700 mb-3">All Staff and Volunteers</h4>
                <ul className="text-sm text-green-600 space-y-1">
                  <li>• Follow this policy and related procedures</li>
                  <li>• Complete mandatory data protection training</li>
                  <li>• Report suspected data breaches immediately</li>
                  <li>• Maintain confidentiality of personal information</li>
                  <li>• Only access data necessary for their role</li>
                </ul>
              </div>
            </div>

            <div className="bg-red-50 border-l-4 border-red-500 p-4 rounded-lg">
              <h4 className="font-semibold text-red-700 mb-2">Management Accountability</h4>
              <p className="text-sm text-red-600">
                Directors and senior management are ultimately accountable for ensuring compliance and must provide
                adequate resources, training, and support for data protection activities.
              </p>
            </div>
          </CardContent>
        </Card>
      </section>

      {/* 4. Principles of Data Protection */}
      <section className="mb-12">
        <Card className="p-6">
          <CardHeader className="p-0 mb-6">
            <CardTitle className="text-2xl font-bold text-vazoOrange flex items-center">
              <Shield className="h-6 w-6 mr-2" />
              4. Principles of Data Protection
            </CardTitle>
          </CardHeader>
          <CardContent className="p-0 space-y-4">
            <p className="text-gray-700">
              We commit to processing personal information in accordance with POPIA's eight conditions for lawful
              processing:
            </p>

            <div className="grid grid-cols-1 md:grid-cols-2 gap-4">
              <div className="border border-gray-200 p-4 rounded-lg">
                <h4 className="font-semibold text-gray-800 mb-2 flex items-center">
                  <span className="bg-vazoOrange text-white rounded-full w-6 h-6 flex items-center justify-center text-sm mr-2">
                    1
                  </span>
                  Accountability
                </h4>
                <p className="text-sm text-gray-600">
                  Information Officer and Deputy Information Officers ensure compliance and can demonstrate adherence to
                  POPIA principles.
                </p>
              </div>

              <div className="border border-gray-200 p-4 rounded-lg">
                <h4 className="font-semibold text-gray-800 mb-2 flex items-center">
                  <span className="bg-vazoOrange text-white rounded-full w-6 h-6 flex items-center justify-center text-sm mr-2">
                    2
                  </span>
                  Processing Limitation
                </h4>
                <p className="text-sm text-gray-600">
                  Information is processed lawfully, reasonably, and minimally, with appropriate consent or legal basis.
                </p>
              </div>

              <div className="border border-gray-200 p-4 rounded-lg">
                <h4 className="font-semibold text-gray-800 mb-2 flex items-center">
                  <span className="bg-vazoOrange text-white rounded-full w-6 h-6 flex items-center justify-center text-sm mr-2">
                    3
                  </span>
                  Purpose Specification
                </h4>
                <p className="text-sm text-gray-600">
                  Information is collected for specific, explicitly defined, and lawful purposes related to our youth
                  empowerment mission.
                </p>
              </div>

              <div className="border border-gray-200 p-4 rounded-lg">
                <h4 className="font-semibold text-gray-800 mb-2 flex items-center">
                  <span className="bg-vazoOrange text-white rounded-full w-6 h-6 flex items-center justify-center text-sm mr-2">
                    4
                  </span>
                  Further Processing Limitation
                </h4>
                <p className="text-sm text-gray-600">
                  Further use of data is compatible with the initial purpose or has additional lawful basis.
                </p>
              </div>

              <div className="border border-gray-200 p-4 rounded-lg">
                <h4 className="font-semibold text-gray-800 mb-2 flex items-center">
                  <span className="bg-vazoOrange text-white rounded-full w-6 h-6 flex items-center justify-center text-sm mr-2">
                    5
                  </span>
                  Information Quality
                </h4>
                <p className="text-sm text-gray-600">
                  Data is complete, accurate, not misleading, and updated where necessary for the purpose.
                </p>
              </div>

              <div className="border border-gray-200 p-4 rounded-lg">
                <h4 className="font-semibold text-gray-800 mb-2 flex items-center">
                  <span className="bg-vazoOrange text-white rounded-full w-6 h-6 flex items-center justify-center text-sm mr-2">
                    6
                  </span>
                  Openness
                </h4>
                <p className="text-sm text-gray-600">
                  Individuals are informed about data collection, usage, and their rights through clear privacy notices.
                </p>
              </div>

              <div className="border border-gray-200 p-4 rounded-lg">
                <h4 className="font-semibold text-gray-800 mb-2 flex items-center">
                  <span className="bg-vazoOrange text-white rounded-full w-6 h-6 flex items-center justify-center text-sm mr-2">
                    7
                  </span>
                  Security Safeguards
                </h4>
                <p className="text-sm text-gray-600">
                  Information is protected against unauthorized access, loss, damage, or destruction through appropriate
                  technical and organizational measures.
                </p>
              </div>

              <div className="border border-gray-200 p-4 rounded-lg">
                <h4 className="font-semibold text-gray-800 mb-2 flex items-center">
                  <span className="bg-vazoOrange text-white rounded-full w-6 h-6 flex items-center justify-center text-sm mr-2">
                    8
                  </span>
                  Data Subject Participation
                </h4>
                <p className="text-sm text-gray-600">
                  Individuals may request access to, correction, or deletion of their personal information.
                </p>
              </div>
            </div>
          </CardContent>
        </Card>
      </section>

      {/* 5. PAIA Compliance */}
      <section className="mb-12">
        <Card className="p-6">
          <CardHeader className="p-0 mb-6">
            <CardTitle className="text-2xl font-bold text-vazoOrange flex items-center">
              <FileText className="h-6 w-6 mr-2" />
              5. PAIA Compliance
            </CardTitle>
          </CardHeader>
          <CardContent className="p-0 space-y-4">
            <p className="text-gray-700">
              We maintain full compliance with the Promotion of Access to Information Act (PAIA) through the following
              mechanisms:
            </p>

            <div className="grid grid-cols-1 md:grid-cols-2 gap-6">
              <div className="bg-blue-50 p-4 rounded-lg">
                <h4 className="font-semibold text-blue-700 mb-3">Annual Reporting</h4>
                <ul className="text-sm text-blue-600 space-y-1">
                  <li>• Submit PAIA Annual Report to the Information Regulator</li>
                  <li>• Report on access requests received and processed</li>
                  <li>• Document any appeals or complaints</li>
                  <li>• Track compliance metrics and improvements</li>
                </ul>
              </div>

              <div className="bg-green-50 p-4 rounded-lg">
                <h4 className="font-semibold text-green-700 mb-3">PAIA Manual</h4>
                <ul className="text-sm text-green-600 space-y-1">
                  <li>• Maintain comprehensive PAIA manual</li>
                  <li>• Make manual available to the public</li>
                  <li>• Update manual annually or as needed</li>
                  <li>• Include clear request procedures</li>
                </ul>
              </div>

              <div className="bg-purple-50 p-4 rounded-lg">
                <h4 className="font-semibold text-purple-700 mb-3">Self-Assessment</h4>
                <ul className="text-sm text-purple-600 space-y-1">
                  <li>• Complete PAIA Self-Assessment Tool via BizPortal</li>
                  <li>• Evaluate compliance gaps and improvements</li>
                  <li>• Implement corrective actions as needed</li>
                  <li>• Document assessment results</li>
                </ul>
              </div>

              <div className="bg-orange-50 p-4 rounded-lg">
                <h4 className="font-semibold text-orange-700 mb-3">Access Request Processing</h4>
                <ul className="text-sm text-orange-600 space-y-1">
                  <li>• Process requests within 30 days</li>
                  <li>• Apply appropriate exemptions where applicable</li>
                  <li>• Maintain detailed request logs</li>
                  <li>• Provide clear reasons for any refusals</li>
                </ul>
              </div>
            </div>
          </CardContent>
        </Card>
      </section>

      {/* 6. Data Security Measures */}
      <section className="mb-12">
        <Card className="p-6">
          <CardHeader className="p-0 mb-6">
            <CardTitle className="text-2xl font-bold text-vazoOrange flex items-center">
              <Lock className="h-6 w-6 mr-2" />
              6. Data Security Measures
            </CardTitle>
          </CardHeader>
          <CardContent className="p-0 space-y-4">
            <p className="text-gray-700">
              We implement comprehensive technical and administrative safeguards to protect personal information:
            </p>

            <div className="grid grid-cols-1 md:grid-cols-2 gap-6">
              <div>
                <h4 className="font-semibold text-gray-800 mb-4">Technical Safeguards</h4>
                <div className="space-y-3">
                  <div className="flex items-start">
                    <CheckCircle className="h-5 w-5 text-green-500 mr-2 mt-0.5" />
                    <div>
                      <p className="font-medium text-sm">Secure Digital Storage</p>
                      <p className="text-xs text-gray-600">Encrypted databases and secure cloud storage</p>
                    </div>
                  </div>
                  <div className="flex items-start">
                    <CheckCircle className="h-5 w-5 text-green-500 mr-2 mt-0.5" />
                    <div>
                      <p className="font-medium text-sm">Access Controls</p>
                      <p className="text-xs text-gray-600">Role-based permissions and multi-factor authentication</p>
                    </div>
                  </div>
                  <div className="flex items-start">
                    <CheckCircle className="h-5 w-5 text-green-500 mr-2 mt-0.5" />
                    <div>
                      <p className="font-medium text-sm">Data Encryption</p>
                      <p className="text-xs text-gray-600">End-to-end encryption for sensitive data</p>
                    </div>
                  </div>
                  <div className="flex items-start">
                    <CheckCircle className="h-5 w-5 text-green-500 mr-2 mt-0.5" />
                    <div>
                      <p className="font-medium text-sm">Network Security</p>
                      <p className="text-xs text-gray-600">Firewalls, intrusion detection, and secure connections</p>
                    </div>
                  </div>
                </div>
              </div>

              <div>
                <h4 className="font-semibold text-gray-800 mb-4">Administrative Safeguards</h4>
                <div className="space-y-3">
                  <div className="flex items-start">
                    <CheckCircle className="h-5 w-5 text-blue-500 mr-2 mt-0.5" />
                    <div>
                      <p className="font-medium text-sm">Staff Training</p>
                      <p className="text-xs text-gray-600">Regular data protection and security awareness training</p>
                    </div>
                  </div>
                  <div className="flex items-start">
                    <CheckCircle className="h-5 w-5 text-blue-500 mr-2 mt-0.5" />
                    <div>
                      <p className="font-medium text-sm">Internal Audits</p>
                      <p className="text-xs text-gray-600">Regular compliance assessments and process reviews</p>
                    </div>
                  </div>
                  <div className="flex items-start">
                    <CheckCircle className="h-5 w-5 text-blue-500 mr-2 mt-0.5" />
                    <div>
                      <p className="font-medium text-sm">Incident Response</p>
                      <p className="text-xs text-gray-600">Comprehensive breach response and recovery procedures</p>
                    </div>
                  </div>
                  <div className="flex items-start">
                    <CheckCircle className="h-5 w-5 text-blue-500 mr-2 mt-0.5" />
                    <div>
                      <p className="font-medium text-sm">Vendor Management</p>
                      <p className="text-xs text-gray-600">Due diligence and contracts for third-party processors</p>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </CardContent>
        </Card>
      </section>

      {/* 7. Reporting & Monitoring */}
      <section className="mb-12">
        <Card className="p-6">
          <CardHeader className="p-0 mb-6">
            <CardTitle className="text-2xl font-bold text-vazoOrange flex items-center">
              <Eye className="h-6 w-6 mr-2" />
              7. Reporting & Monitoring
            </CardTitle>
          </CardHeader>
          <CardContent className="p-0 space-y-4">
            <div className="grid grid-cols-1 md:grid-cols-2 gap-6">
              <div className="bg-blue-50 p-4 rounded-lg">
                <h4 className="font-semibold text-blue-700 mb-3">Information Officer Responsibilities</h4>
                <ul className="text-sm text-blue-600 space-y-1">
                  <li>• Ensure all required reports are submitted to the Information Regulator</li>
                  <li>• Monitor compliance across all departments and programs</li>
                  <li>• Coordinate with external auditors and regulators</li>
                  <li>• Maintain comprehensive compliance documentation</li>
                </ul>
              </div>

              <div className="bg-red-50 p-4 rounded-lg">
                <h4 className="font-semibold text-red-700 mb-3">Incident Reporting</h4>
                <ul className="text-sm text-red-600 space-y-1">
                  <li>• All staff must immediately report suspected data breaches to the Information Officer</li>
                  <li>• Breach notification to authorities within 72 hours as required</li>
                  <li>• Detailed incident logs and corrective action documentation</li>
                  <li>• Regular incident trend analysis and prevention measures</li>
                </ul>
              </div>

              <div className="bg-green-50 p-4 rounded-lg">
                <h4 className="font-semibold text-green-700 mb-3">Compliance Training</h4>
                <ul className="text-sm text-green-600 space-y-1">
                  <li>• Mandatory POPIA training for all new staff and volunteers</li>
                  <li>• Annual refresher training and updates</li>
                  <li>• Specialized training for high-risk roles</li>
                  <li>• Training completion tracking and certification</li>
                </ul>
              </div>

              <div className="bg-purple-50 p-4 rounded-lg">
                <h4 className="font-semibold text-purple-700 mb-3">Performance Monitoring</h4>
                <ul className="text-sm text-purple-600 space-y-1">
                  <li>• Regular compliance audits and assessments</li>
                  <li>• Key performance indicators for data protection</li>
                  <li>• Continuous improvement initiatives</li>
                  <li>• Stakeholder feedback and complaint resolution</li>
                </ul>
              </div>
            </div>

            <div className="bg-gray-50 p-4 rounded-lg">
              <h4 className="font-semibold text-gray-800 mb-2">Emergency Contact Procedures</h4>
              <p className="text-sm text-gray-600 mb-2">For urgent data protection incidents or breaches:</p>
              <p className="text-sm text-gray-600">
                📧{" "}
                <a href="mailto:databreach@vazofoundations.org" className="text-red-600 font-bold hover:underline">
                  databreach@vazofoundations.org
                </a>{" "}
                | 📞{" "}
                <a href="tel:0878222686" className="text-red-600 font-bold hover:underline">
                  0878222686
                </a>{" "}
                (24/7 availability)
              </p>
            </div>
          </CardContent>
        </Card>
      </section>

      {/* 8. Enforcement */}
      <section className="mb-12">
        <Card className="p-6">
          <CardHeader className="p-0 mb-6">
            <CardTitle className="text-2xl font-bold text-vazoOrange flex items-center">
              <AlertTriangle className="h-6 w-6 mr-2" />
              8. Enforcement
            </CardTitle>
          </CardHeader>
          <CardContent className="p-0 space-y-4">
            <p className="text-gray-700">
              Non-compliance with this policy may result in serious consequences for individuals and the organization:
            </p>

            <div className="grid grid-cols-1 md:grid-cols-2 gap-6">
              <div className="bg-red-50 p-4 rounded-lg border-l-4 border-red-500">
                <h4 className="font-semibold text-red-700 mb-3">Individual Consequences</h4>
                <ul className="text-sm text-red-600 space-y-1">
                  <li>• Verbal or written warnings</li>
                  <li>• Mandatory additional training</li>
                  <li>• Suspension of access privileges</li>
                  <li>• Disciplinary action up to termination</li>
                  <li>• Personal liability for damages</li>
                  <li>• Potential criminal charges for serious breaches</li>
                </ul>
              </div>

              <div className="bg-orange-50 p-4 rounded-lg border-l-4 border-orange-500">
                <h4 className="font-semibold text-orange-700 mb-3">Organizational Risks</h4>
                <ul className="text-sm text-orange-600 space-y-1">
                  <li>• Regulatory fines and penalties</li>
                  <li>• Reputational damage and loss of trust</li>
                  <li>• Legal action from affected individuals</li>
                  <li>• Loss of funding and partnerships</li>
                  <li>• Operational disruption and costs</li>
                  <li>• Regulatory sanctions and oversight</li>
                </ul>
              </div>
            </div>

            <div className="bg-blue-50 p-4 rounded-lg">
              <h4 className="font-semibold text-blue-700 mb-2">Progressive Discipline Approach</h4>
              <p className="text-sm text-blue-600 mb-2">
                We follow a progressive discipline approach, considering factors such as:
              </p>
              <ul className="text-sm text-blue-600 space-y-1">
                <li>• Severity and impact of the violation</li>
                <li>• Intent and circumstances surrounding the incident</li>
                <li>• Previous compliance history</li>
                <li>• Cooperation with investigation and remediation</li>
                <li>• Potential for rehabilitation and improvement</li>
              </ul>
            </div>
          </CardContent>
        </Card>
      </section>

      {/* 9. Review */}
      <section className="mb-12">
        <Card className="p-6">
          <CardHeader className="p-0 mb-6">
            <CardTitle className="text-2xl font-bold text-vazoOrange flex items-center">
              <FileText className="h-6 w-6 mr-2" />
              9. Review and Updates
            </CardTitle>
          </CardHeader>
          <CardContent className="p-0 space-y-4">
            <p className="text-gray-700">
              This policy is reviewed and updated regularly to ensure continued effectiveness and compliance:
            </p>

            <div className="grid grid-cols-1 md:grid-cols-2 gap-6">
              <div className="bg-green-50 p-4 rounded-lg">
                <h4 className="font-semibold text-green-700 mb-3">Regular Review Schedule</h4>
                <ul className="text-sm text-green-600 space-y-1">
                  <li>• Annual comprehensive policy review</li>
                  <li>• Quarterly compliance assessment</li>
                  <li>• Monthly incident and trend analysis</li>
                  <li>• Ad-hoc reviews following significant incidents</li>
                </ul>
              </div>

              <div className="bg-blue-50 p-4 rounded-lg">
                <h4 className="font-semibold text-blue-700 mb-3">Update Triggers</h4>
                <ul className="text-sm text-blue-600 space-y-1">
                  <li>• Changes in POPIA or PAIA legislation</li>
                  <li>• New regulatory guidance or requirements</li>
                  <li>• Organizational structure or process changes</li>
                  <li>• Technology system updates or implementations</li>
                </ul>
              </div>
            </div>

            <div className="bg-gray-50 p-4 rounded-lg">
              <h4 className="font-semibold text-gray-800 mb-2">Stakeholder Involvement</h4>
              <p className="text-sm text-gray-600">
                Policy reviews involve input from directors, department heads, the Information Officer, legal advisors,
                and relevant external experts to ensure comprehensive coverage and practical implementation.
              </p>
            </div>
          </CardContent>
        </Card>
      </section>

      {/* Contact Information */}
      <section className="mb-12">
        <Card className="p-6 bg-gray-50">
          <CardHeader className="p-0 mb-6">
            <CardTitle className="text-2xl font-bold text-vazoOrange flex items-center">
              <Phone className="h-6 w-6 mr-2" />
              Contact Information
            </CardTitle>
          </CardHeader>
          <CardContent className="p-0 space-y-4">
            <p className="text-gray-700">
              For questions about this policy, compliance concerns, or data protection matters, contact:
            </p>

            <div className="grid grid-cols-1 md:grid-cols-2 gap-6">
              <div className="bg-white p-4 rounded-lg border">
                <h4 className="font-semibold text-gray-800 mb-3">Information Officer</h4>
                <div className="space-y-2 text-sm text-gray-600">
                  <p>
                    <strong>Sebastian Hendricks</strong>
                  </p>
                  <p>Director of Digital Strategy & Systems</p>
                  <p>
                    📧{" "}
                    <a href="mailto:privacy@vazofoundations.org" className="text-vazoOrange hover:underline">
                      privacy@vazofoundations.org
                    </a>
                  </p>
                  <p>
                    📞{" "}
                    <a href="tel:0878222686" className="text-vazoOrange hover:underline">
                      0878222686
                    </a>
                  </p>
                  <p>📍 10a Flamingo Way, Pelican Park, Cape Town</p>
                </div>
              </div>

              <div className="bg-white p-4 rounded-lg border">
                <h4 className="font-semibold text-gray-800 mb-3">General Inquiries</h4>
                <div className="space-y-2 text-sm text-gray-600">
                  <p>
                    📧{" "}
                    <a href="mailto:info@vazofoundations.org" className="text-vazoOrange hover:underline">
                      info@vazofoundations.org
                    </a>
                  </p>
                  <p>
                    📞{" "}
                    <a href="tel:0878222686" className="text-vazoOrange hover:underline">
                      0878222686
                    </a>
                  </p>
                  <p>🌐 www.vazofoundations.org</p>
                  <p>
                    📘{" "}
                    <a
                      href="https://www.facebook.com/profile.php?id=61580244223428"
                      className="text-vazoOrange hover:underline"
                      target="_blank"
                      rel="noopener noreferrer"
                    >
                      Facebook
                    </a>
                  </p>
                </div>
              </div>
            </div>

            <div className="bg-red-50 border-l-4 border-red-500 p-4 rounded-lg">
              <h4 className="font-semibold text-red-700 mb-2">Emergency Data Breach Reporting</h4>
              <p className="text-sm text-red-600">
                📧{" "}
                <a href="mailto:databreach@vazofoundations.org" className="hover:underline font-bold">
                  databreach@vazofoundations.org
                </a>{" "}
                | Available 24/7 for urgent incidents
              </p>
            </div>
          </CardContent>
        </Card>
      </section>

      {/* Footer Actions */}
      <section className="text-center">
        <div className="bg-vazoOrange text-white p-8 rounded-lg">
          <h3 className="text-2xl font-bold mb-4">Committed to Data Protection Excellence</h3>
          <p className="mb-6">
            This policy reflects our unwavering commitment to protecting personal information while fulfilling our
            mission of youth empowerment and community safety.
          </p>
          <div className="flex flex-col sm:flex-row gap-4 justify-center">
            <Link
              href="mailto:privacy@vazofoundations.org"
              className="bg-white text-vazoOrange px-6 py-3 rounded-lg font-semibold hover:bg-gray-100 transition-colors"
            >
              Contact Information Officer
            </Link>
            <Link
              href="/privacy-policy"
              className="border-2 border-white text-white px-6 py-3 rounded-lg font-semibold hover:bg-white hover:text-vazoOrange transition-colors"
            >
              View Privacy Policy
            </Link>
          </div>
        </div>
      </section>
    </div>
  )
}
