import { Button } from "@/components/ui/button"
import { Card, CardContent, CardDescription, CardHeader, CardTitle } from "@/components/ui/card"
import { Badge } from "@/components/ui/badge"
import { Alert, AlertDescription } from "@/components/ui/alert"
import { Heart, DollarSign, Shield, Users, BookOpen, Activity, Info, ArrowRight } from "lucide-react"
import Link from "next/link"
import Image from "next/image"

export default function DonatePage() {
  return (
    <div className="min-h-screen">
      {/* Hero Section */}
      <section className="relative bg-gradient-to-br from-purple-600 via-pink-600 to-red-600 text-white py-20 overflow-hidden">
        <div className="absolute inset-0 bg-black/20"></div>
        <div className="absolute inset-0 bg-[url('/community-empowerment-background.jpg')] bg-cover bg-center opacity-10"></div>

        <div className="container mx-auto px-4 relative z-10">
          <div className="max-w-4xl mx-auto text-center">
            <div className="flex justify-center mb-6">
              <Image
                src="/vazo-foundation-logo.png"
                alt="VAZO Foundation Logo"
                width={80}
                height={80}
                className="rounded-full bg-white/10 p-2"
              />
            </div>

            <Badge className="mb-6 bg-white/20 text-white border-white/30 hover:bg-white/30">Support Our Mission</Badge>

            <h1 className="text-4xl md:text-6xl font-bold mb-6 leading-tight">
              Make a Donation
              <span className="block text-yellow-300">Invest in Our Community</span>
            </h1>

            <p className="text-xl md:text-2xl mb-8 text-purple-100 max-w-3xl mx-auto">
              Your contribution helps us build a safer, stronger community in Pelican Park, Cape Town through youth
              empowerment and protection programs.
            </p>
          </div>
        </div>
      </section>

      {/* Tax Deductible Notice */}
      <section className="py-8 bg-blue-50">
        <div className="container mx-auto px-4">
          <Alert className="max-w-4xl mx-auto border-blue-200 bg-blue-50">
            <Info className="h-4 w-4 text-blue-600" />
            <AlertDescription className="text-blue-800">
              <strong>Section 18A Status:</strong> We are currently in the process of applying for Section 18A status.
              Once approved, your donations will be tax-deductible. We'll notify all donors when this status is
              confirmed.
            </AlertDescription>
          </Alert>
        </div>
      </section>

      {/* Impact Areas */}
      <section className="py-16">
        <div className="container mx-auto px-4">
          <div className="text-center mb-12">
            <h2 className="text-3xl md:text-4xl font-bold mb-4 text-gray-800">Where Your Donation Goes</h2>
            <p className="text-xl text-gray-600 max-w-2xl mx-auto">
              Every rand you donate directly supports our programs and initiatives in Pelican Park, Cape Town.
            </p>
          </div>

          <div className="grid md:grid-cols-2 lg:grid-cols-3 gap-8 max-w-6xl mx-auto">
            {/* Child Protection */}
            <Card className="border-t-4 border-t-red-500 hover:shadow-lg transition-shadow">
              <CardHeader className="text-center">
                <div className="mx-auto bg-red-100 w-16 h-16 rounded-full flex items-center justify-center mb-4">
                  <Shield className="h-8 w-8 text-red-600" />
                </div>
                <CardTitle className="text-red-800">Child Protection</CardTitle>
                <CardDescription>Safeguarding our community's children</CardDescription>
              </CardHeader>
              <CardContent>
                <ul className="text-sm text-gray-600 space-y-2">
                  <li>• Safety training and awareness programs</li>
                  <li>• Incident reporting systems</li>
                  <li>• Support for at-risk youth</li>
                  <li>• Community safety initiatives</li>
                </ul>
              </CardContent>
            </Card>

            {/* Youth Development */}
            <Card className="border-t-4 border-t-blue-500 hover:shadow-lg transition-shadow">
              <CardHeader className="text-center">
                <div className="mx-auto bg-blue-100 w-16 h-16 rounded-full flex items-center justify-center mb-4">
                  <Users className="h-8 w-8 text-blue-600" />
                </div>
                <CardTitle className="text-blue-800">Youth Development</CardTitle>
                <CardDescription>Empowering the next generation</CardDescription>
              </CardHeader>
              <CardContent>
                <ul className="text-sm text-gray-600 space-y-2">
                  <li>• Mentorship programs</li>
                  <li>• Leadership development</li>
                  <li>• Life skills training</li>
                  <li>• Peer support networks</li>
                </ul>
              </CardContent>
            </Card>

            {/* Skills Training */}
            <Card className="border-t-4 border-t-green-500 hover:shadow-lg transition-shadow">
              <CardHeader className="text-center">
                <div className="mx-auto bg-green-100 w-16 h-16 rounded-full flex items-center justify-center mb-4">
                  <BookOpen className="h-8 w-8 text-green-600" />
                </div>
                <CardTitle className="text-green-800">Skills Training</CardTitle>
                <CardDescription>Building pathways to employment</CardDescription>
              </CardHeader>
              <CardContent>
                <ul className="text-sm text-gray-600 space-y-2">
                  <li>• Digital literacy programs</li>
                  <li>• Job readiness coaching</li>
                  <li>• Technical skills workshops</li>
                  <li>• Entrepreneurship support</li>
                </ul>
              </CardContent>
            </Card>

            {/* Health & Wellness */}
            <Card className="border-t-4 border-t-purple-500 hover:shadow-lg transition-shadow">
              <CardHeader className="text-center">
                <div className="mx-auto bg-purple-100 w-16 h-16 rounded-full flex items-center justify-center mb-4">
                  <Activity className="h-8 w-8 text-purple-600" />
                </div>
                <CardTitle className="text-purple-800">Health & Wellness</CardTitle>
                <CardDescription>Supporting mental and physical health</CardDescription>
              </CardHeader>
              <CardContent>
                <ul className="text-sm text-gray-600 space-y-2">
                  <li>• Mental health support</li>
                  <li>• Sports and recreation</li>
                  <li>• Health education</li>
                  <li>• Family wellness programs</li>
                </ul>
              </CardContent>
            </Card>

            {/* Technology Platforms */}
            <Card className="border-t-4 border-t-orange-500 hover:shadow-lg transition-shadow">
              <CardHeader className="text-center">
                <div className="mx-auto bg-orange-100 w-16 h-16 rounded-full flex items-center justify-center mb-4">
                  <DollarSign className="h-8 w-8 text-orange-600" />
                </div>
                <CardTitle className="text-orange-800">Technology Platforms</CardTitle>
                <CardDescription>Digital solutions for community safety</CardDescription>
              </CardHeader>
              <CardContent>
                <ul className="text-sm text-gray-600 space-y-2">
                  <li>• Vigilant safety platform</li>
                  <li>• VAZO Link opportunity matching</li>
                  <li>• Community communication tools</li>
                  <li>• Data management systems</li>
                </ul>
              </CardContent>
            </Card>

            {/* Operational Support */}
            <Card className="border-t-4 border-t-gray-500 hover:shadow-lg transition-shadow">
              <CardHeader className="text-center">
                <div className="mx-auto bg-gray-100 w-16 h-16 rounded-full flex items-center justify-center mb-4">
                  <Heart className="h-8 w-8 text-gray-600" />
                </div>
                <CardTitle className="text-gray-800">Operational Support</CardTitle>
                <CardDescription>Keeping our programs running</CardDescription>
              </CardHeader>
              <CardContent>
                <ul className="text-sm text-gray-600 space-y-2">
                  <li>• Staff development and training</li>
                  <li>• Program materials and resources</li>
                  <li>• Facility maintenance</li>
                  <li>• Administrative costs</li>
                </ul>
              </CardContent>
            </Card>
          </div>
        </div>
      </section>

      {/* Donation Options */}
      <section className="py-16 bg-gray-50">
        <div className="container mx-auto px-4">
          <div className="text-center mb-12">
            <h2 className="text-3xl md:text-4xl font-bold mb-4 text-gray-800">How to Donate</h2>
            <p className="text-xl text-gray-600 max-w-2xl mx-auto">
              Choose the donation method that works best for you. Every contribution makes a difference.
            </p>
          </div>

          <div className="grid md:grid-cols-2 gap-8 max-w-4xl mx-auto">
            {/* Bank Transfer */}
            <Card className="border-blue-200 hover:shadow-lg transition-shadow">
              <CardHeader>
                <CardTitle className="text-blue-800 text-center">Bank Transfer</CardTitle>
                <CardDescription className="text-center">Direct deposit to our account</CardDescription>
              </CardHeader>
              <CardContent className="space-y-4">
                <div className="bg-blue-50 p-4 rounded-lg">
                  <p className="text-sm text-gray-600 mb-2">
                    <strong>Account Name:</strong> VAZO Foundation NPC
                  </p>
                  <p className="text-sm text-gray-600 mb-2">
                    <strong>Bank:</strong> [Bank Name]
                  </p>
                  <p className="text-sm text-gray-600 mb-2">
                    <strong>Account Number:</strong> [Account Number]
                  </p>
                  <p className="text-sm text-gray-600 mb-2">
                    <strong>Branch Code:</strong> [Branch Code]
                  </p>
                  <p className="text-sm text-gray-600">
                    <strong>Reference:</strong> Your Name + "Donation"
                  </p>
                </div>
                <p className="text-sm text-gray-600">
                  Please email us at{" "}
                  <Link href="mailto:info@vazofoundations.org" className="text-blue-600 hover:underline">
                    info@vazofoundations.org
                  </Link>{" "}
                  with your proof of payment.
                </p>
              </CardContent>
            </Card>

            {/* Contact for Other Methods */}
            <Card className="border-green-200 hover:shadow-lg transition-shadow">
              <CardHeader>
                <CardTitle className="text-green-800 text-center">Other Donation Methods</CardTitle>
                <CardDescription className="text-center">We're setting up additional options</CardDescription>
              </CardHeader>
              <CardContent className="space-y-4">
                <div className="text-center">
                  <p className="text-gray-600 mb-4">
                    We're currently setting up online donation platforms and other convenient payment methods.
                  </p>
                  <p className="text-gray-600 mb-4">For now, please contact us to discuss your donation:</p>
                  <div className="space-y-2">
                    <Button asChild variant="outline" className="w-full bg-transparent">
                      <Link href="mailto:info@vazofoundations.org">Email: info@vazofoundations.org</Link>
                    </Button>
                    <Button asChild variant="outline" className="w-full bg-transparent">
                      <Link href="tel: 0878222686">Phone: 087 822 2686</Link>
                    </Button>
                  </div>
                </div>
              </CardContent>
            </Card>
          </div>
        </div>
      </section>

      {/* Transparency */}
      <section className="py-16">
        <div className="container mx-auto px-4">
          <div className="max-w-4xl mx-auto">
            <div className="text-center mb-12">
              <h2 className="text-3xl md:text-4xl font-bold mb-4 text-gray-800">Our Commitment to Transparency</h2>
              <p className="text-xl text-gray-600">
                We believe in complete transparency about how your donations are used.
              </p>
            </div>

            <div className="grid md:grid-cols-2 gap-8">
              <Card className="border-blue-200">
                <CardHeader>
                  <CardTitle className="text-blue-800">Financial Accountability</CardTitle>
                </CardHeader>
                <CardContent>
                  <ul className="space-y-2 text-gray-600">
                    <li>• Annual financial reports published</li>
                    <li>• Regular program impact updates</li>
                    <li>• Donor acknowledgment and receipts</li>
                    <li>• Independent financial oversight</li>
                  </ul>
                </CardContent>
              </Card>

              <Card className="border-green-200">
                <CardHeader>
                  <CardTitle className="text-green-800">Registration Details</CardTitle>
                </CardHeader>
                <CardContent>
                  <div className="space-y-2 text-gray-600">
                    <p>
                      <strong>Organization:</strong> VAZO Foundation NPC
                    </p>
                    <p>
                      <strong>Registration No:</strong> 2025 / 634473 / 08
                    </p>
                    <p>
                      <strong>Status:</strong> Non-Profit Company
                    </p>
                    <p>
                      <strong>Section 18A:</strong> Application in progress
                    </p>
                  </div>
                </CardContent>
              </Card>
            </div>
          </div>
        </div>
      </section>

      {/* Call to Action */}
      <section className="py-16 bg-gradient-to-r from-purple-600 to-pink-600 text-white">
        <div className="container mx-auto px-4">
          <div className="max-w-4xl mx-auto text-center">
            <h2 className="text-3xl md:text-4xl font-bold mb-6">Ready to Make a Difference?</h2>
            <p className="text-xl mb-8 text-purple-100">
              Your donation today helps build a safer, stronger community for the youth of Pelican Park, Cape Town.
            </p>

            <div className="flex flex-col sm:flex-row gap-4 justify-center">
              <Button asChild size="lg" variant="secondary" className="bg-white text-purple-700 hover:bg-gray-100">
                <Link href="mailto:info@vazofoundations.org">
                  Contact Us to Donate
                  <Heart className="ml-2 h-5 w-5" />
                </Link>
              </Button>
              <Button
                asChild
                size="lg"
                variant="outline"
                className="border-white text-white hover:bg-white/10 bg-transparent"
              >
                <Link href="/get-involved">
                  Other Ways to Help
                  <ArrowRight className="ml-2 h-5 w-5" />
                </Link>
              </Button>
            </div>
          </div>
        </div>
      </section>
    </div>
  )
}
