import { Button } from "@/components/ui/button"
import { Card, CardContent, CardDescription, CardHeader, CardTitle } from "@/components/ui/card"
import { Badge } from "@/components/ui/badge"
import { Users, Heart, Briefcase, ArrowRight, Phone, Mail } from "lucide-react"
import Link from "next/link"

export default function GetInvolvedPage() {
  return (
    <div className="min-h-screen">
      {/* Hero Section */}
      <section className="relative bg-gradient-to-br from-green-600 via-blue-600 to-purple-600 text-white py-20 overflow-hidden">
        <div className="absolute inset-0 bg-black/20"></div>
        <div className="absolute inset-0 bg-[url('/community-empowerment-background.jpg')] bg-cover bg-center opacity-10"></div>

        <div className="container mx-auto px-4 relative z-10">
          <div className="max-w-4xl mx-auto text-center">
            <Badge className="mb-6 bg-white/20 text-white border-white/30 hover:bg-white/30">Join Our Mission</Badge>

            <h1 className="text-4xl md:text-6xl font-bold mb-6 leading-tight">
              Get Involved
              <span className="block text-yellow-300">Make a Difference</span>
            </h1>

            <p className="text-xl md:text-2xl mb-8 text-green-100 max-w-3xl mx-auto">
              Join us in building a safer, stronger community in Pelican Park, Cape Town. Every contribution matters.
            </p>
          </div>
        </div>
      </section>

      {/* Ways to Get Involved */}
      <section className="py-16">
        <div className="container mx-auto px-4">
          <div className="text-center mb-12">
            <h2 className="text-3xl md:text-4xl font-bold mb-4 text-gray-800">Ways to Get Involved</h2>
            <p className="text-xl text-gray-600 max-w-2xl mx-auto">
              Choose how you'd like to contribute to our mission of empowering youth and building safer communities.
            </p>
          </div>

          <div className="grid md:grid-cols-2 lg:grid-cols-3 gap-8 max-w-6xl mx-auto">
            {/* Volunteer */}
            <Card className="border-t-4 border-t-blue-500 hover:shadow-lg transition-shadow group">
              <CardHeader className="text-center">
                <div className="mx-auto bg-blue-100 w-16 h-16 rounded-full flex items-center justify-center mb-4 group-hover:bg-blue-200 transition-colors">
                  <Users className="h-8 w-8 text-blue-600" />
                </div>
                <CardTitle className="text-2xl text-blue-800">Volunteer</CardTitle>
                <CardDescription className="text-lg">Join our team of dedicated volunteers</CardDescription>
              </CardHeader>
              <CardContent className="text-center space-y-4">
                <p className="text-gray-600">
                  Share your skills and time to directly impact young lives in our community. From mentoring to program
                  support, there's a place for everyone.
                </p>
                <ul className="text-sm text-gray-600 space-y-1">
                  <li>• Mentorship programs</li>
                  <li>• Skills workshop facilitation</li>
                  <li>• Community event support</li>
                  <li>• Administrative assistance</li>
                </ul>
                <Button asChild className="w-full bg-blue-600 hover:bg-blue-700">
                  <Link href="/get-involved/volunteer">
                    Apply to Volunteer
                    <ArrowRight className="ml-2 h-4 w-4" />
                  </Link>
                </Button>
              </CardContent>
            </Card>

            {/* Partner */}
            <Card className="border-t-4 border-t-green-500 hover:shadow-lg transition-shadow group">
              <CardHeader className="text-center">
                <div className="mx-auto bg-green-100 w-16 h-16 rounded-full flex items-center justify-center mb-4 group-hover:bg-green-200 transition-colors">
                  <Briefcase className="h-8 w-8 text-green-600" />
                </div>
                <CardTitle className="text-2xl text-green-800">Partner</CardTitle>
                <CardDescription className="text-lg">Collaborate with us for greater impact</CardDescription>
              </CardHeader>
              <CardContent className="text-center space-y-4">
                <p className="text-gray-600">
                  Join forces with VAZO Foundation to amplify our community impact through strategic partnerships and
                  collaborative initiatives.
                </p>
                <ul className="text-sm text-gray-600 space-y-1">
                  <li>• Corporate partnerships</li>
                  <li>• Educational collaborations</li>
                  <li>• Community organization alliances</li>
                  <li>• Resource sharing agreements</li>
                </ul>
                <Button asChild className="w-full bg-green-600 hover:bg-green-700">
                  <Link href="/get-involved/partner">
                    Become a Partner
                    <ArrowRight className="ml-2 h-4 w-4" />
                  </Link>
                </Button>
              </CardContent>
            </Card>

            {/* Donate */}
            <Card className="border-t-4 border-t-purple-500 hover:shadow-lg transition-shadow group md:col-span-2 lg:col-span-1">
              <CardHeader className="text-center">
                <div className="mx-auto bg-purple-100 w-16 h-16 rounded-full flex items-center justify-center mb-4 group-hover:bg-purple-200 transition-colors">
                  <Heart className="h-8 w-8 text-purple-600" />
                </div>
                <CardTitle className="text-2xl text-purple-800">Donate</CardTitle>
                <CardDescription className="text-lg">Support our programs financially</CardDescription>
              </CardHeader>
              <CardContent className="text-center space-y-4">
                <p className="text-gray-600">
                  Your financial contribution helps us expand our programs, reach more youth, and create lasting change
                  in our community.
                </p>
                <ul className="text-sm text-gray-600 space-y-1">
                  <li>• Program funding</li>
                  <li>• Equipment and resources</li>
                  <li>• Staff development</li>
                  <li>• Community infrastructure</li>
                </ul>
                <Button asChild className="w-full bg-purple-600 hover:bg-purple-700">
                  <Link href="/get-involved/donate">
                    Make a Donation
                    <Heart className="ml-2 h-4 w-4" />
                  </Link>
                </Button>
              </CardContent>
            </Card>
          </div>
        </div>
      </section>

      {/* Impact Statistics */}
      <section className="py-16 bg-gray-50">
        <div className="container mx-auto px-4">
          <div className="text-center mb-12">
            <h2 className="text-3xl md:text-4xl font-bold mb-4 text-gray-800">Our Impact Together</h2>
            <p className="text-xl text-gray-600 max-w-2xl mx-auto">
              See how community involvement is making a real difference in Pelican Park, Cape Town.
            </p>
          </div>

          <div className="grid md:grid-cols-2 lg:grid-cols-4 gap-8 max-w-4xl mx-auto">
            <Card className="text-center bg-white border-0 shadow-lg">
              <CardContent className="pt-6">
                <div className="text-4xl font-bold text-blue-600 mb-2">50+</div>
                <p className="text-gray-600">Youth Served</p>
              </CardContent>
            </Card>
            <Card className="text-center bg-white border-0 shadow-lg">
              <CardContent className="pt-6">
                <div className="text-4xl font-bold text-green-600 mb-2">25+</div>
                <p className="text-gray-600">Active Volunteers</p>
              </CardContent>
            </Card>
            <Card className="text-center bg-white border-0 shadow-lg">
              <CardContent className="pt-6">
                <div className="text-4xl font-bold text-purple-600 mb-2">10+</div>
                <p className="text-gray-600">Community Partners</p>
              </CardContent>
            </Card>
            <Card className="text-center bg-white border-0 shadow-lg">
              <CardContent className="pt-6">
                <div className="text-4xl font-bold text-orange-600 mb-2">100%</div>
                <p className="text-gray-600">Community Focused</p>
              </CardContent>
            </Card>
          </div>
        </div>
      </section>

      {/* Contact Section */}
      <section className="py-16">
        <div className="container mx-auto px-4">
          <div className="max-w-4xl mx-auto">
            <div className="text-center mb-12">
              <h2 className="text-3xl md:text-4xl font-bold mb-4 text-gray-800">Ready to Get Started?</h2>
              <p className="text-xl text-gray-600">
                Have questions or want to learn more? We're here to help you find the perfect way to get involved.
              </p>
            </div>

            <div className="grid md:grid-cols-2 gap-8">
              <Card className="border-blue-200 hover:shadow-lg transition-shadow">
                <CardHeader>
                  <CardTitle className="text-blue-800 flex items-center">
                    <Mail className="mr-2 h-5 w-5" />
                    Email Us
                  </CardTitle>
                  <CardDescription>Get in touch with our team</CardDescription>
                </CardHeader>
                <CardContent>
                  <p className="text-gray-600 mb-4">
                    Send us an email and we'll get back to you within 24 hours to discuss how you can get involved.
                  </p>
                  <Button asChild variant="outline" className="w-full bg-transparent">
                    <Link href="mailto:info@vazofoundations.org">info@vazofoundations.org</Link>
                  </Button>
                </CardContent>
              </Card>

              <Card className="border-green-200 hover:shadow-lg transition-shadow">
                <CardHeader>
                  <CardTitle className="text-green-800 flex items-center">
                    <Phone className="mr-2 h-5 w-5" />
                    Call Us
                  </CardTitle>
                  <CardDescription>Speak directly with our team</CardDescription>
                </CardHeader>
                <CardContent>
                  <p className="text-gray-600 mb-4">
                    Call us during business hours to discuss volunteer opportunities, partnerships, or donations.
                  </p>
                  <Button asChild variant="outline" className="w-full bg-transparent">
                    <Link href="tel:+27021XXXXXXX">+27 (0) 21 XXX XXXX</Link>
                  </Button>
                </CardContent>
              </Card>
            </div>
          </div>
        </div>
      </section>

      {/* Call to Action */}
      <section className="py-16 bg-gradient-to-r from-blue-600 to-green-600 text-white">
        <div className="container mx-auto px-4">
          <div className="max-w-4xl mx-auto text-center">
            <h2 className="text-3xl md:text-4xl font-bold mb-6">Join Our Community Today</h2>
            <p className="text-xl mb-8 text-blue-100">
              Every action, no matter how small, contributes to building a safer, stronger community in Pelican Park,
              Cape Town.
            </p>

            <div className="flex flex-col sm:flex-row gap-4 justify-center">
              <Button asChild size="lg" variant="secondary" className="bg-white text-blue-700 hover:bg-gray-100">
                <Link href="/get-involved/volunteer">
                  Start Volunteering
                  <Users className="ml-2 h-5 w-5" />
                </Link>
              </Button>
              <Button asChild size="lg" variant="secondary" className="bg-white text-green-700 hover:bg-gray-100">
                <Link href="/get-involved/partner">
                  Become a Partner
                  <Briefcase className="ml-2 h-5 w-5" />
                </Link>
              </Button>
              <Button
                asChild
                size="lg"
                variant="outline"
                className="border-white text-white hover:bg-white/10 bg-transparent"
              >
                <Link href="/get-involved/donate">
                  Make a Donation
                  <Heart className="ml-2 h-5 w-5" />
                </Link>
              </Button>
            </div>
          </div>
        </div>
      </section>
    </div>
  )
}
