import { Button } from "@/components/ui/button"
import { Card, CardContent, CardDescription, CardHeader, CardTitle } from "@/components/ui/card"
import { Badge } from "@/components/ui/badge"
import Link from "next/link"
import Image from "next/image"
import {
  Users,
  GraduationCap,
  Heart,
  Shield,
  Target,
  Phone,
  AlertTriangle,
  CheckCircle,
  ArrowRight,
  Star,
  Award,
  TrendingUp,
} from "lucide-react"

export default function HomePage() {
  return (
    <div className="flex flex-col min-h-screen">
      {/* Hero Section */}
      <section className="relative bg-gradient-to-br from-blue-50 to-orange-50 py-20 md:py-32">
        <div className="container mx-auto px-4">
          <div className="grid grid-cols-1 lg:grid-cols-2 gap-12 items-center">
            <div className="space-y-8">
              <div className="space-y-4">
                <Badge variant="secondary" className="bg-vazoOrange/10 text-vazoOrange border-vazoOrange/20">
                  Building Child-Safe Communities
                </Badge>
                <h1 className="text-4xl md:text-6xl font-bold text-gray-900 leading-tight">
                  Empowering Youth,
                  <span className="text-vazoOrange"> Protecting Children</span>
                </h1>
                <p className="text-xl text-gray-600 leading-relaxed">
                  VAZO Foundation NPC is dedicated to building child-safe communities in Pelican Park and surrounding
                  areas through comprehensive youth development, skills training, and innovative community safety
                  programs.
                </p>
              </div>

              {/* Key Stats */}
              <div className="grid grid-cols-2 gap-6">
                <div className="text-center">
                  <div className="text-3xl font-bold text-vazoOrange">500+</div>
                  <div className="text-sm text-gray-600">Youth Empowered</div>
                </div>
                <div className="text-center">
                  <div className="text-3xl font-bold text-vazoOrange">100+</div>
                  <div className="text-sm text-gray-600">Volunteers Active</div>
                </div>
              </div>

              <div className="flex flex-col sm:flex-row gap-4">
                <Button asChild size="lg" className="bg-vazoOrange hover:bg-vazoOrange/90 text-white">
                  <Link href="/get-involved/volunteer">
                    Get Involved <ArrowRight className="ml-2 h-4 w-4" />
                  </Link>
                </Button>
                <Button
                  asChild
                  variant="outline"
                  size="lg"
                  className="border-vazoOrange text-vazoOrange hover:bg-vazoOrange/10 bg-transparent"
                >
                  <Link href="/programs">Explore Programs</Link>
                </Button>
              </div>
            </div>

            <div className="relative">
              <Image
                src="/images/design-mode/ChatGPT%20Image%20Sep%2010%2C%202025%2C%2006_56_57%20PM.png"
                alt="Stick figure illustration of youth empowerment and community building activities"
                width={600}
                height={400}
                className="rounded-lg shadow-2xl object-cover"
                priority
              />
              <div className="absolute -bottom-6 -left-6 bg-white p-4 rounded-lg shadow-lg">
                <div className="flex items-center space-x-2">
                  <CheckCircle className="h-5 w-5 text-green-500" />
                  <span className="text-sm font-medium">Child Protection Certified</span>
                </div>
              </div>
            </div>
          </div>
        </div>
      </section>

      {/* Emergency Actions */}
      <section className="bg-white py-8 border-b">
        <div className="container mx-auto px-4">
          <div className="flex flex-col md:flex-row items-center justify-center gap-4">
            <div className="text-center md:text-left">
              <h2 className="text-lg font-semibold text-gray-800 mb-2">Need Immediate Support?</h2>
              <p className="text-gray-600">We're here to help families and report safety concerns.</p>
            </div>
            <div className="flex flex-col sm:flex-row gap-3">
              <Button asChild className="bg-green-600 hover:bg-green-700 text-white">
                <Link href="/parent-support">
                  <Phone className="mr-2 h-4 w-4" />
                  Parent Support
                </Link>
              </Button>
              <Button asChild variant="destructive">
                <Link href="/report-incident">
                  <AlertTriangle className="mr-2 h-4 w-4" />
                  Report Incident
                </Link>
              </Button>
            </div>
          </div>
        </div>
      </section>

      {/* Programs Overview */}
      <section className="py-20 bg-gray-50">
        <div className="container mx-auto px-4">
          <div className="text-center mb-16">
            <h2 className="text-3xl md:text-4xl font-bold text-gray-900 mb-4">
              Our <span className="text-vazoOrange">Programs</span>
            </h2>
            <p className="text-xl text-gray-600 max-w-3xl mx-auto">
              Comprehensive programs designed to empower youth, strengthen families, and build safer communities through
              education, mentorship, and innovative technology solutions.
            </p>
          </div>

          <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
            {/* Active Programs */}
            <Card className="hover:shadow-lg transition-shadow">
              <CardHeader>
                <div className="flex items-center justify-between">
                  <GraduationCap className="h-8 w-8 text-vazoOrange" />
                  <Badge variant="secondary" className="bg-green-100 text-green-700">
                    Active
                  </Badge>
                </div>
                <CardTitle>Skills Workshops</CardTitle>
                <CardDescription>
                  Weekly coding and digital literacy bootcamps providing hands-on training in high-demand technical
                  skills.
                </CardDescription>
              </CardHeader>
              <CardContent>
                <Button asChild variant="outline" className="w-full bg-transparent">
                  <Link href="/programs/skills-workshops">Learn More</Link>
                </Button>
              </CardContent>
            </Card>

            <Card className="hover:shadow-lg transition-shadow">
              <CardHeader>
                <div className="flex items-center justify-between">
                  <Users className="h-8 w-8 text-vazoOrange" />
                  <Badge variant="secondary" className="bg-green-100 text-green-700">
                    Active
                  </Badge>
                </div>
                <CardTitle>Mentorship Circles</CardTitle>
                <CardDescription>
                  Monthly group coaching sessions connecting young people with experienced industry professionals.
                </CardDescription>
              </CardHeader>
              <CardContent>
                <Button asChild variant="outline" className="w-full bg-transparent">
                  <Link href="/programs/mentorship-circles">Learn More</Link>
                </Button>
              </CardContent>
            </Card>

            <Card className="hover:shadow-lg transition-shadow">
              <CardHeader>
                <div className="flex items-center justify-between">
                  <Heart className="h-8 w-8 text-vazoOrange" />
                  <Badge variant="secondary" className="bg-green-100 text-green-700">
                    Active
                  </Badge>
                </div>
                <CardTitle>Health & Wellness</CardTitle>
                <CardDescription>
                  Mental health support, sports programs, and trauma-informed care for holistic wellbeing.
                </CardDescription>
              </CardHeader>
              <CardContent>
                <Button asChild variant="outline" className="w-full bg-transparent">
                  <Link href="/programs/health-wellness">Learn More</Link>
                </Button>
              </CardContent>
            </Card>

            {/* Programs Under Development */}
            <Card className="hover:shadow-lg transition-shadow opacity-90">
              <CardHeader>
                <div className="flex items-center justify-between">
                  <Shield className="h-8 w-8 text-vazoOrange" />
                  <Badge variant="secondary" className="bg-yellow-100 text-yellow-700">
                    In Development
                  </Badge>
                </div>
                <CardTitle>Vigilant Program</CardTitle>
                <CardDescription>
                  Community safety technology platform for incident reporting and coordinated emergency response.
                </CardDescription>
              </CardHeader>
              <CardContent>
                <Button asChild variant="outline" className="w-full bg-transparent">
                  <Link href="/programs/vigilant">Learn More & Subscribe</Link>
                </Button>
              </CardContent>
            </Card>

            <Card className="hover:shadow-lg transition-shadow opacity-90">
              <CardHeader>
                <div className="flex items-center justify-between">
                  <Target className="h-8 w-8 text-vazoOrange" />
                  <Badge variant="secondary" className="bg-orange-100 text-orange-700">
                    Under Construction
                  </Badge>
                </div>
                <CardTitle>Vazo Link</CardTitle>
                <CardDescription>
                  AI-powered opportunity matching platform connecting youth with mentors, jobs, and services.
                </CardDescription>
              </CardHeader>
              <CardContent>
                <Button asChild variant="outline" className="w-full bg-transparent">
                  <Link href="/programs/vazo-link">Join Waitlist</Link>
                </Button>
              </CardContent>
            </Card>

            <Card className="hover:shadow-lg transition-shadow">
              <CardHeader>
                <div className="flex items-center justify-between">
                  <Shield className="h-8 w-8 text-vazoOrange" />
                  <Badge variant="secondary" className="bg-blue-100 text-blue-700">
                    Essential
                  </Badge>
                </div>
                <CardTitle>Child Protection</CardTitle>
                <CardDescription>
                  Comprehensive safeguarding policies, training, and support systems to protect children in our
                  community.
                </CardDescription>
              </CardHeader>
              <CardContent>
                <Button asChild variant="outline" className="w-full bg-transparent">
                  <Link href="/about/child-protection">Learn More</Link>
                </Button>
              </CardContent>
            </Card>
          </div>
        </div>
      </section>

      {/* Impact Section */}
      <section className="py-20 bg-white">
        <div className="container mx-auto px-4">
          <div className="text-center mb-16">
            <h2 className="text-3xl md:text-4xl font-bold text-gray-900 mb-4">
              Our <span className="text-vazoOrange">Impact</span>
            </h2>
            <p className="text-xl text-gray-600 max-w-3xl mx-auto">
              Measuring success through real outcomes and lasting change in our community.
            </p>
          </div>

          <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-8">
            <div className="text-center">
              <div className="bg-vazoOrange/10 rounded-full w-16 h-16 flex items-center justify-center mx-auto mb-4">
                <Users className="h-8 w-8 text-vazoOrange" />
              </div>
              <div className="text-3xl font-bold text-gray-900 mb-2">500+</div>
              <div className="text-gray-600">Youth Empowered</div>
            </div>

            <div className="text-center">
              <div className="bg-vazoOrange/10 rounded-full w-16 h-16 flex items-center justify-center mx-auto mb-4">
                <TrendingUp className="h-8 w-8 text-vazoOrange" />
              </div>
              <div className="text-3xl font-bold text-gray-900 mb-2">95%</div>
              <div className="text-gray-600">Success Rate</div>
            </div>

            <div className="text-center">
              <div className="bg-vazoOrange/10 rounded-full w-16 h-16 flex items-center justify-center mx-auto mb-4">
                <Award className="h-8 w-8 text-vazoOrange" />
              </div>
              <div className="text-3xl font-bold text-gray-900 mb-2">50+</div>
              <div className="text-gray-600">Skills Certifications</div>
            </div>

            <div className="text-center">
              <div className="bg-vazoOrange/10 rounded-full w-16 h-16 flex items-center justify-center mx-auto mb-4">
                <Star className="h-8 w-8 text-vazoOrange" />
              </div>
              <div className="text-3xl font-bold text-gray-900 mb-2">15+</div>
              <div className="text-gray-600">Partner Organizations</div>
            </div>
          </div>
        </div>
      </section>

      {/* Call to Action */}
      <section className="py-20 bg-vazoOrange text-white">
        <div className="container mx-auto px-4 text-center">
          <h2 className="text-3xl md:text-4xl font-bold mb-6">Ready to Make a Difference?</h2>
          <p className="text-xl mb-8 max-w-2xl mx-auto opacity-90">
            Join our community of volunteers, partners, and supporters working together to build a safer, more empowered
            future for our youth.
          </p>
          <div className="flex flex-col sm:flex-row gap-4 justify-center">
            <Button asChild size="lg" variant="secondary" className="bg-white text-vazoOrange hover:bg-gray-100">
              <Link href="/get-involved/volunteer">Become a Volunteer</Link>
            </Button>
            <Button
              asChild
              size="lg"
              variant="outline"
              className="border-white text-white hover:bg-white hover:text-vazoOrange bg-transparent"
            >
              <Link href="/get-involved/donate">Support Our Mission</Link>
            </Button>
          </div>
        </div>
      </section>
    </div>
  )
}
