import { Card, CardContent } from "@/components/ui/card"
import { Shield, Lock, Eye, Mail } from "lucide-react"

export default function PrivacyPolicyPage() {
  return (
    <div className="min-h-screen bg-gradient-to-b from-gray-50 to-white">
      <div className="container mx-auto px-4 py-16 max-w-4xl">
        <div className="text-center mb-12">
          <Shield className="h-16 w-16 text-blue-600 mx-auto mb-4" />
          <h1 className="text-4xl font-bold text-gray-900 mb-4">Privacy Policy</h1>
          <p className="text-gray-600 text-lg">
            Your privacy is important to us. This policy explains how we collect, use, and protect your personal
            information.
          </p>
          <p className="text-sm text-gray-500 mt-2">Last Updated: January 2025</p>
        </div>

        <div className="space-y-8">
          <Card>
            <CardContent className="p-8">
              <div className="flex items-start gap-4 mb-6">
                <Lock className="h-6 w-6 text-blue-600 mt-1 flex-shrink-0" />
                <div>
                  <h2 className="text-2xl font-semibold text-gray-900 mb-3">1. Introduction</h2>
                  <p className="text-gray-600 leading-relaxed mb-4">
                    VAZO Foundation NPC ("we," "us," or "our") is committed to protecting your personal information and
                    your right to privacy. This Privacy Policy describes how we collect, use, disclose, and safeguard
                    your information when you visit our website or use our services.
                  </p>
                  <p className="text-gray-600 leading-relaxed">
                    We are registered as a Non-Profit Company (NPC) in South Africa and comply with the Protection of
                    Personal Information Act (POPIA) and other applicable data protection regulations.
                  </p>
                </div>
              </div>
            </CardContent>
          </Card>

          <Card>
            <CardContent className="p-8">
              <div className="flex items-start gap-4 mb-6">
                <Eye className="h-6 w-6 text-blue-600 mt-1 flex-shrink-0" />
                <div>
                  <h2 className="text-2xl font-semibold text-gray-900 mb-3">2. Information We Collect</h2>
                  <p className="text-gray-600 leading-relaxed mb-4">
                    We collect information that you voluntarily provide to us when you:
                  </p>
                  <ul className="list-disc list-inside space-y-2 text-gray-600 mb-4">
                    <li>Register for programs or services</li>
                    <li>Submit volunteer applications</li>
                    <li>Make donations or process payments</li>
                    <li>Contact us through forms or email</li>
                    <li>Subscribe to newsletters or updates</li>
                    <li>Participate in surveys or feedback forms</li>
                  </ul>
                  <p className="text-gray-600 leading-relaxed mb-3 font-semibold">
                    Types of personal information we may collect include:
                  </p>
                  <div className="bg-gray-50 p-4 rounded-lg space-y-2 text-sm">
                    <p className="text-gray-700">
                      <strong>Contact Information:</strong> Name, email address, phone number, physical address
                    </p>
                    <p className="text-gray-700">
                      <strong>Demographic Information:</strong> Age, gender, date of birth, ethnicity (optional)
                    </p>
                    <p className="text-gray-700">
                      <strong>Professional Information:</strong> Employment status, education level, skills and
                      qualifications
                    </p>
                    <p className="text-gray-700">
                      <strong>Financial Information:</strong> Payment details for donations (processed securely through
                      third-party payment processors)
                    </p>
                    <p className="text-gray-700">
                      <strong>Program-Specific Information:</strong> Emergency contacts, medical information (if
                      relevant), program preferences
                    </p>
                    <p className="text-gray-700">
                      <strong>Technical Information:</strong> IP address, browser type, device information, cookies
                    </p>
                  </div>
                </div>
              </div>
            </CardContent>
          </Card>

          <Card>
            <CardContent className="p-8">
              <h2 className="text-2xl font-semibold text-gray-900 mb-6">3. Purpose of Processing</h2>
              <p className="text-gray-600 leading-relaxed mb-4">
                We process your personal information for the following purposes in accordance with POPIA:
              </p>
              <div className="overflow-x-auto">
                <table className="w-full border-collapse">
                  <thead>
                    <tr className="bg-blue-50">
                      <th className="border border-gray-300 px-4 py-3 text-left font-semibold text-gray-900">
                        Category
                      </th>
                      <th className="border border-gray-300 px-4 py-3 text-left font-semibold text-gray-900">
                        Purpose
                      </th>
                      <th className="border border-gray-300 px-4 py-3 text-left font-semibold text-gray-900">
                        Examples
                      </th>
                    </tr>
                  </thead>
                  <tbody>
                    <tr className="hover:bg-gray-50">
                      <td className="border border-gray-300 px-4 py-3 font-medium text-gray-900">Service Delivery</td>
                      <td className="border border-gray-300 px-4 py-3 text-gray-700">
                        To provide and manage our programs and services
                      </td>
                      <td className="border border-gray-300 px-4 py-3 text-gray-600 text-sm">
                        Program enrollment, volunteer coordination, support services
                      </td>
                    </tr>
                    <tr className="hover:bg-gray-50">
                      <td className="border border-gray-300 px-4 py-3 font-medium text-gray-900">Communication</td>
                      <td className="border border-gray-300 px-4 py-3 text-gray-700">
                        To communicate with you about our activities
                      </td>
                      <td className="border border-gray-300 px-4 py-3 text-gray-600 text-sm">
                        Newsletters, program updates, event invitations
                      </td>
                    </tr>
                    <tr className="hover:bg-gray-50">
                      <td className="border border-gray-300 px-4 py-3 font-medium text-gray-900">Legal Compliance</td>
                      <td className="border border-gray-300 px-4 py-3 text-gray-700">
                        To comply with legal obligations
                      </td>
                      <td className="border border-gray-300 px-4 py-3 text-gray-600 text-sm">
                        Tax reporting, safeguarding requirements, regulatory compliance
                      </td>
                    </tr>
                    <tr className="hover:bg-gray-50">
                      <td className="border border-gray-300 px-4 py-3 font-medium text-gray-900">
                        Improvement & Research
                      </td>
                      <td className="border border-gray-300 px-4 py-3 text-gray-700">
                        To improve our services and understand impact
                      </td>
                      <td className="border border-gray-300 px-4 py-3 text-gray-600 text-sm">
                        Program evaluation, impact assessment, service improvement
                      </td>
                    </tr>
                  </tbody>
                </table>
              </div>
            </CardContent>
          </Card>

          <Card>
            <CardContent className="p-8">
              <h2 className="text-2xl font-semibold text-gray-900 mb-4">4. Legal Basis for Processing</h2>
              <p className="text-gray-600 leading-relaxed mb-4">
                Under POPIA, we process your personal information based on:
              </p>
              <ul className="list-disc list-inside space-y-2 text-gray-600">
                <li>
                  <strong>Consent:</strong> When you explicitly agree to provide your information
                </li>
                <li>
                  <strong>Contractual Necessity:</strong> To fulfill our obligations in providing services to you
                </li>
                <li>
                  <strong>Legal Obligation:</strong> To comply with legal requirements (e.g., safeguarding, tax laws)
                </li>
                <li>
                  <strong>Legitimate Interests:</strong> For our organizational operations, provided your rights are not
                  overridden
                </li>
              </ul>
            </CardContent>
          </Card>

          <Card>
            <CardContent className="p-8">
              <h2 className="text-2xl font-semibold text-gray-900 mb-4">5. How We Share Your Information</h2>
              <p className="text-gray-600 leading-relaxed mb-4">
                We do not sell your personal information. We may share your information with:
              </p>
              <div className="space-y-3">
                <div className="bg-blue-50 p-4 rounded-lg">
                  <p className="font-semibold text-gray-900 mb-1">Service Providers</p>
                  <p className="text-sm text-gray-600">
                    Third-party vendors who assist with operations (e.g., email services, payment processors, database
                    management)
                  </p>
                </div>
                <div className="bg-blue-50 p-4 rounded-lg">
                  <p className="font-semibold text-gray-900 mb-1">Partner Organizations</p>
                  <p className="text-sm text-gray-600">
                    Trusted partners who collaborate on programs (only with your consent and as necessary)
                  </p>
                </div>
                <div className="bg-blue-50 p-4 rounded-lg">
                  <p className="font-semibold text-gray-900 mb-1">Legal Authorities</p>
                  <p className="text-sm text-gray-600">
                    When required by law or to protect the safety of individuals (e.g., safeguarding concerns)
                  </p>
                </div>
                <div className="bg-blue-50 p-4 rounded-lg">
                  <p className="font-semibold text-gray-900 mb-1">Funders & Donors</p>
                  <p className="text-sm text-gray-600">
                    Anonymized aggregate data for reporting purposes (no personal identifiers)
                  </p>
                </div>
              </div>
            </CardContent>
          </Card>

          <Card>
            <CardContent className="p-8">
              <h2 className="text-2xl font-semibold text-gray-900 mb-4">6. Data Security</h2>
              <p className="text-gray-600 leading-relaxed mb-4">
                We implement appropriate technical and organizational measures to protect your personal information,
                including:
              </p>
              <ul className="list-disc list-inside space-y-2 text-gray-600">
                <li>Encryption of sensitive data (SSL/TLS)</li>
                <li>Secure servers and databases</li>
                <li>Access controls and authentication</li>
                <li>Regular security audits and updates</li>
                <li>Staff training on data protection</li>
              </ul>
              <p className="text-gray-600 leading-relaxed mt-4">
                However, no method of transmission over the internet is 100% secure. We cannot guarantee absolute
                security but will notify you of any data breaches as required by law.
              </p>
            </CardContent>
          </Card>

          <Card>
            <CardContent className="p-8">
              <h2 className="text-2xl font-semibold text-gray-900 mb-4">7. Data Retention</h2>
              <p className="text-gray-600 leading-relaxed mb-4">
                We retain your personal information only for as long as necessary to fulfill the purposes outlined in
                this policy, unless a longer retention period is required by law. Typical retention periods include:
              </p>
              <ul className="list-disc list-inside space-y-2 text-gray-600">
                <li>
                  <strong>Program Participants:</strong> Duration of participation + 7 years (for safeguarding and legal
                  compliance)
                </li>
                <li>
                  <strong>Volunteers:</strong> Duration of volunteering + 7 years
                </li>
                <li>
                  <strong>Donors:</strong> 7 years (for tax and accounting purposes)
                </li>
                <li>
                  <strong>Website Users:</strong> As necessary for the purpose collected
                </li>
              </ul>
            </CardContent>
          </Card>

          <Card>
            <CardContent className="p-8">
              <h2 className="text-2xl font-semibold text-gray-900 mb-4">8. Your Rights (POPIA)</h2>
              <p className="text-gray-600 leading-relaxed mb-4">
                Under the Protection of Personal Information Act (POPIA), you have the right to:
              </p>
              <div className="grid md:grid-cols-2 gap-4">
                <div className="bg-gray-50 p-4 rounded-lg">
                  <p className="font-semibold text-gray-900 mb-2">Access</p>
                  <p className="text-sm text-gray-600">Request a copy of your personal information we hold</p>
                </div>
                <div className="bg-gray-50 p-4 rounded-lg">
                  <p className="font-semibold text-gray-900 mb-2">Correction</p>
                  <p className="text-sm text-gray-600">Request correction of inaccurate information</p>
                </div>
                <div className="bg-gray-50 p-4 rounded-lg">
                  <p className="font-semibold text-gray-900 mb-2">Deletion</p>
                  <p className="text-sm text-gray-600">
                    Request deletion of your information (subject to legal obligations)
                  </p>
                </div>
                <div className="bg-gray-50 p-4 rounded-lg">
                  <p className="font-semibold text-gray-900 mb-2">Objection</p>
                  <p className="text-sm text-gray-600">Object to processing of your information</p>
                </div>
                <div className="bg-gray-50 p-4 rounded-lg">
                  <p className="font-semibold text-gray-900 mb-2">Restriction</p>
                  <p className="text-sm text-gray-600">Request restriction of processing</p>
                </div>
                <div className="bg-gray-50 p-4 rounded-lg">
                  <p className="font-semibold text-gray-900 mb-2">Withdraw Consent</p>
                  <p className="text-sm text-gray-600">
                    Withdraw consent at any time (where processing is based on consent)
                  </p>
                </div>
              </div>
              <p className="text-gray-600 leading-relaxed mt-4">
                To exercise these rights, please contact us at <strong>info@vazofoundation.org</strong>. We will respond
                within 30 days.
              </p>
            </CardContent>
          </Card>

          <Card>
            <CardContent className="p-8">
              <h2 className="text-2xl font-semibold text-gray-900 mb-4">9. Children's Privacy</h2>
              <p className="text-gray-600 leading-relaxed">
                We are committed to protecting the privacy of children and young people. We only collect personal
                information from children with parental or guardian consent. If we become aware that we have collected
                information from a child without proper consent, we will take steps to delete it.
              </p>
            </CardContent>
          </Card>

          <Card>
            <CardContent className="p-8">
              <h2 className="text-2xl font-semibold text-gray-900 mb-4">10. Cookies and Tracking</h2>
              <p className="text-gray-600 leading-relaxed mb-4">
                Our website uses cookies and similar tracking technologies to improve user experience. You can control
                cookie settings through your browser. Types of cookies we use:
              </p>
              <ul className="list-disc list-inside space-y-2 text-gray-600">
                <li>
                  <strong>Essential Cookies:</strong> Required for website functionality
                </li>
                <li>
                  <strong>Analytics Cookies:</strong> Help us understand how visitors use our site
                </li>
                <li>
                  <strong>Preference Cookies:</strong> Remember your settings and preferences
                </li>
              </ul>
            </CardContent>
          </Card>

          <Card>
            <CardContent className="p-8">
              <h2 className="text-2xl font-semibold text-gray-900 mb-4">11. Changes to This Policy</h2>
              <p className="text-gray-600 leading-relaxed">
                We may update this Privacy Policy from time to time. Changes will be posted on this page with an updated
                "Last Updated" date. We encourage you to review this policy periodically. Continued use of our services
                after changes constitutes acceptance of the updated policy.
              </p>
            </CardContent>
          </Card>

          <Card className="border-2 border-blue-600">
            <CardContent className="p-8">
              <div className="flex items-start gap-4">
                <Mail className="h-6 w-6 text-blue-600 mt-1 flex-shrink-0" />
                <div>
                  <h2 className="text-2xl font-semibold text-gray-900 mb-4">12. Contact Us</h2>
                  <p className="text-gray-600 leading-relaxed mb-4">
                    If you have any questions, concerns, or requests regarding this Privacy Policy or our data
                    practices, please contact us:
                  </p>
                  <div className="bg-blue-50 p-6 rounded-lg space-y-2">
                    <p className="text-gray-900">
                      <strong>VAZO Foundation NPC</strong>
                    </p>
                    <p className="text-gray-700">Email: info@vazofoundation.org</p>
                    <p className="text-gray-700">Phone: +27 (0)21 XXX XXXX</p>
                    <p className="text-gray-700">Address: Pelican Park, Cape Town, South Africa</p>
                  </div>
                  <div className="mt-4 p-4 bg-yellow-50 border-l-4 border-yellow-400">
                    <p className="text-sm text-gray-700">
                      <strong>Information Regulator:</strong> If you are not satisfied with our response, you have the
                      right to lodge a complaint with the Information Regulator of South Africa at{" "}
                      <a href="https://www.justice.gov.za/inforeg/" className="text-blue-600 hover:underline">
                        www.justice.gov.za/inforeg
                      </a>
                    </p>
                  </div>
                </div>
              </div>
            </CardContent>
          </Card>
        </div>

        <div className="mt-12 text-center text-sm text-gray-500">
          <p>© 2025 VAZO Foundation NPC. All rights reserved.</p>
          <p className="mt-2">Registered Non-Profit Company in South Africa</p>
        </div>
      </div>
    </div>
  )
}
