import { Button } from "@/components/ui/button"
import { Card, CardContent, CardHeader, CardTitle } from "@/components/ui/card"
import { Heart, Activity, Brain, Users, Shield, Smile } from "lucide-react"
import Link from "next/link"
import Image from "next/image"

export default function HealthWellnessPage() {
  return (
    <div className="container mx-auto px-4 py-8 md:py-16">
      <h1 className="text-4xl font-bold mb-6 text-center text-vazoOrange">Health & Wellness Programs</h1>
      <p className="text-lg text-gray-700 text-center max-w-3xl mx-auto mb-8">
        Comprehensive health and wellness support for youth and families, including mental health services, sports and
        recreation programs, and trauma-informed care to promote holistic wellbeing.
      </p>

      <section className="space-y-6">
        <h2 className="text-3xl font-bold text-gray-800 flex items-center justify-center gap-2 text-center">
          <Heart className="h-8 w-8 text-vazoOrange" aria-hidden="true" /> Holistic Wellbeing Support
        </h2>

        {/* Key Programs */}
        <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8 mt-8">
          <Card className="p-6 text-center">
            <Brain className="h-12 w-12 text-vazoOrange mb-4 mx-auto" />
            <CardTitle className="text-xl font-bold mb-3">Mental Health Support</CardTitle>
            <CardContent className="p-0">
              <p className="text-gray-700">
                Trauma-informed mental health screening, counseling services, and referral pathways to specialized care
                providers.
              </p>
            </CardContent>
          </Card>

          <Card className="p-6 text-center">
            <Activity className="h-12 w-12 text-vazoOrange mb-4 mx-auto" />
            <CardTitle className="text-xl font-bold mb-3">Sports & Recreation</CardTitle>
            <CardContent className="p-0">
              <p className="text-gray-700">
                Pro-social engagement through organized sports, recreational activities, and fitness programs that build
                community connections.
              </p>
            </CardContent>
          </Card>

          <Card className="p-6 text-center">
            <Shield className="h-12 w-12 text-vazoOrange mb-4 mx-auto" />
            <CardTitle className="text-xl font-bold mb-3">Trauma-Informed Care</CardTitle>
            <CardContent className="p-0">
              <p className="text-gray-700">
                Specialized support for youth who have experienced trauma, with trained counselors and evidence-based
                interventions.
              </p>
            </CardContent>
          </Card>

          <Card className="p-6 text-center">
            <Users className="h-12 w-12 text-vazoOrange mb-4 mx-auto" />
            <CardTitle className="text-xl font-bold mb-3">Caregiver Workshops</CardTitle>
            <CardContent className="p-0">
              <p className="text-gray-700">
                Educational workshops for parents and caregivers on child development, mental health awareness, and
                family wellness.
              </p>
            </CardContent>
          </Card>

          <Card className="p-6 text-center">
            <Smile className="h-12 w-12 text-vazoOrange mb-4 mx-auto" />
            <CardTitle className="text-xl font-bold mb-3">Peer Support Groups</CardTitle>
            <CardContent className="p-0">
              <p className="text-gray-700">
                Safe spaces for youth to connect with peers, share experiences, and build supportive relationships under
                professional guidance.
              </p>
            </CardContent>
          </Card>

          <Card className="p-6 text-center">
            <Heart className="h-12 w-12 text-vazoOrange mb-4 mx-auto" />
            <CardTitle className="text-xl font-bold mb-3">Wellness Education</CardTitle>
            <CardContent className="p-0">
              <p className="text-gray-700">
                Health education programs covering nutrition, hygiene, substance abuse prevention, and healthy lifestyle
                choices.
              </p>
            </CardContent>
          </Card>
        </div>

        {/* Mental Health Services */}
        <section className="mt-12 bg-blue-50 p-8 rounded-lg">
          <h3 className="text-2xl font-bold text-center mb-8 text-blue-800">Mental Health Services</h3>
          <div className="grid grid-cols-1 md:grid-cols-2 gap-8">
            <div>
              <h4 className="text-xl font-bold mb-4 text-blue-700">Screening & Assessment</h4>
              <ul className="space-y-2 text-blue-600">
                <li>• Initial mental health screening for all participants</li>
                <li>• Risk assessment and safety planning</li>
                <li>• Ongoing monitoring and evaluation</li>
                <li>• Referrals to specialized services when needed</li>
              </ul>
            </div>
            <div>
              <h4 className="text-xl font-bold mb-4 text-blue-700">Support Services</h4>
              <ul className="space-y-2 text-blue-600">
                <li>• Individual counseling sessions</li>
                <li>• Group therapy and support circles</li>
                <li>• Crisis intervention and emergency support</li>
                <li>• Family therapy and mediation</li>
              </ul>
            </div>
          </div>
        </section>

        {/* Sports & Recreation */}
        <section className="mt-12">
          <h3 className="text-2xl font-bold text-center mb-8 text-gray-800">Sports & Recreation Programs</h3>
          <div className="grid grid-cols-1 md:grid-cols-3 gap-6">
            <Card className="p-6 bg-green-50">
              <CardHeader className="p-0 mb-4">
                <CardTitle className="text-lg font-bold text-green-700">Team Sports</CardTitle>
              </CardHeader>
              <CardContent className="p-0">
                <ul className="text-sm text-green-600 space-y-1">
                  <li>• Soccer leagues</li>
                  <li>• Basketball tournaments</li>
                  <li>• Netball competitions</li>
                  <li>• Rugby development</li>
                </ul>
              </CardContent>
            </Card>

            <Card className="p-6 bg-purple-50">
              <CardHeader className="p-0 mb-4">
                <CardTitle className="text-lg font-bold text-purple-700">Individual Activities</CardTitle>
              </CardHeader>
              <CardContent className="p-0">
                <ul className="text-sm text-purple-600 space-y-1">
                  <li>• Athletics and running</li>
                  <li>• Swimming programs</li>
                  <li>• Martial arts classes</li>
                  <li>• Fitness training</li>
                </ul>
              </CardContent>
            </Card>

            <Card className="p-6 bg-orange-50">
              <CardHeader className="p-0 mb-4">
                <CardTitle className="text-lg font-bold text-orange-700">Creative Recreation</CardTitle>
              </CardHeader>
              <CardContent className="p-0">
                <ul className="text-sm text-orange-600 space-y-1">
                  <li>• Dance and movement</li>
                  <li>• Music and drama</li>
                  <li>• Art therapy sessions</li>
                  <li>• Outdoor adventures</li>
                </ul>
              </CardContent>
            </Card>
          </div>
        </section>

        {/* Partner Network */}
        <section className="mt-12 bg-gray-50 p-8 rounded-lg">
          <h3 className="text-2xl font-bold text-center mb-8 text-gray-800">Our Health & Wellness Partners</h3>
          <div className="grid grid-cols-1 md:grid-cols-3 gap-6">
            <div className="text-center">
              <h4 className="font-bold text-vazoOrange mb-4">Healthcare Providers</h4>
              <ul className="text-sm text-gray-600 space-y-2">
                <li>Local clinics and hospitals</li>
                <li>Community health centers</li>
                <li>Mobile health units</li>
                <li>Specialized pediatric services</li>
              </ul>
            </div>
            <div className="text-center">
              <h4 className="font-bold text-vazoOrange mb-4">Mental Health Services</h4>
              <ul className="text-sm text-gray-600 space-y-2">
                <li>Trauma counseling centers</li>
                <li>Child psychologists</li>
                <li>Family therapy services</li>
                <li>Crisis intervention teams</li>
              </ul>
            </div>
            <div className="text-center">
              <h4 className="font-bold text-vazoOrange mb-4">Recreation Partners</h4>
              <ul className="text-sm text-gray-600 space-y-2">
                <li>Local sports clubs</li>
                <li>Community centers</li>
                <li>Schools and facilities</li>
                <li>Youth development organizations</li>
              </ul>
            </div>
          </div>
        </section>

        {/* Emergency Support */}
        <section className="mt-12 bg-red-50 border-l-4 border-red-500 p-6 rounded-lg">
          <h3 className="text-xl font-bold text-red-700 mb-4">Crisis Support & Emergency Services</h3>
          <div className="grid grid-cols-1 md:grid-cols-2 gap-6">
            <div>
              <h4 className="font-semibold text-red-700 mb-2">24/7 Crisis Hotlines</h4>
              <ul className="text-sm text-red-600 space-y-1">
                <li>
                  • Suicide Prevention:{" "}
                  <a href="tel:0800567567" className="font-bold hover:underline">
                    0800 567 567
                  </a>
                </li>
                <li>
                  • Mental Health Crisis:{" "}
                  <a href="tel:0800121314" className="font-bold hover:underline">
                    0800 121 314
                  </a>
                </li>
                <li>
                  • Substance Abuse:{" "}
                  <a href="tel:0800435748" className="font-bold hover:underline">
                    0800 435 748
                  </a>
                </li>
              </ul>
            </div>
            <div>
              <h4 className="font-semibold text-red-700 mb-2">Emergency Interventions</h4>
              <ul className="text-sm text-red-600 space-y-1">
                <li>• Mobile crisis response teams</li>
                <li>• Emergency counseling sessions</li>
                <li>• Safety planning and risk assessment</li>
                <li>• Immediate referrals to specialized care</li>
              </ul>
            </div>
          </div>
        </section>

        <div className="grid grid-cols-1 sm:grid-cols-2 gap-4 mt-6 max-w-4xl mx-auto">
          <Image
            src="/youth-participating-in-sports-activities.jpg"
            width={300}
            height={200}
            alt="Youth participating in sports and recreation programs"
            className="rounded-lg object-cover w-full"
            loading="lazy"
          />
          <Image
            src="/mental-health-counseling.png"
            width={300}
            height={200}
            alt="Mental health counseling and support session"
            className="rounded-lg object-cover w-full"
            loading="lazy"
          />
        </div>

        <div className="text-center mt-8">
          <div className="flex flex-col sm:flex-row gap-4 justify-center">
            <Button asChild className="bg-vazoOrange hover:bg-vazoOrange/90 text-white">
              <Link href="/get-involved/volunteer">Volunteer as a Wellness Coach</Link>
            </Button>
            <Button
              asChild
              variant="outline"
              className="border-vazoOrange text-vazoOrange hover:bg-vazoOrange/10 bg-transparent"
            >
              <Link href="mailto:wellness@vazofoundations.org">Contact Our Wellness Team</Link>
            </Button>
          </div>
        </div>
      </section>
    </div>
  )
}
