import { Button } from "@/components/ui/button"
import Link from "next/link"
import { Briefcase } from "lucide-react"
import Image from "next/image"

export default function JobReadinessCoachingPage() {
  return (
    <div className="container mx-auto px-4 py-8 md:py-16">
      <h1 className="text-4xl font-bold mb-6 text-center text-vazoOrange">Job-Readiness Coaching</h1>
      <p className="text-lg text-gray-700 text-center max-w-3xl mx-auto mb-8">
        We provide comprehensive support to ensure our graduates are fully prepared for the job market. This includes CV
        building, interview preparation, and direct job placement assistance, connecting them with potential employers
        and internship opportunities.
      </p>

      <section className="space-y-6">
        <h2 className="text-3xl font-bold text-gray-800 flex items-center justify-center gap-2 text-center">
          <Briefcase className="h-8 w-8 text-vazoOrange" aria-hidden="true" /> Our Approach
        </h2>
        <ul className="list-disc list-inside text-gray-700 space-y-2 max-w-2xl mx-auto">
          <li>Professional CV and Cover Letter Writing</li>
          <li>Interview Skills Training and Mock Interviews</li>
          <li>Job Search Strategies and Application Support</li>
          <li>Post-Placement Support and Follow-up</li>
          <li>Workplace Ethics and Professionalism</li>
          <li>Financial Literacy for Young Professionals</li>
        </ul>
        <div className="grid grid-cols-1 sm:grid-cols-2 md:grid-cols-3 gap-4 mt-6 max-w-5xl mx-auto">
          <Image
            src="/placeholder.svg?height=200&width=300"
            width={300}
            height={200}
            alt="Job interview training session"
            className="rounded-lg object-cover w-full"
            loading="lazy"
          />
          <Image
            src="/placeholder.svg?height=200&width=300"
            width={300}
            height={200}
            alt="CV building workshop"
            className="rounded-lg object-cover w-full"
            loading="lazy"
          />
          <Image
            src="/placeholder.svg?height=200&width=300"
            width={300}
            height={200}
            alt="Youth at a career fair"
            className="rounded-lg object-cover w-full"
            loading="lazy"
          />
        </div>
        <div className="text-center mt-8">
          <Button asChild className="bg-vazoOrange hover:bg-vazoOrange/90 text-white">
            <Link href="/programs/job-readiness-coaching/apply">Apply for Job-Readiness Coaching</Link>
          </Button>
        </div>
      </section>
    </div>
  )
}
