import { Button } from "@/components/ui/button"
import Link from "next/link"
import { Users } from "lucide-react"
import Image from "next/image"

export default function MentorshipCirclesPage() {
  return (
    <div className="container mx-auto px-4 py-8 md:py-16">
      <h1 className="text-4xl font-bold mb-6 text-center text-vazoOrange">Mentorship Circles</h1>
      <p className="text-lg text-gray-700 text-center max-w-3xl mx-auto mb-8">
        Our monthly group coaching sessions connect young people with experienced industry experts. These circles
        provide invaluable guidance, career insights, and personal development support, helping mentees navigate their
        career paths and build professional networks.
      </p>

      <section className="space-y-6">
        <h2 className="text-3xl font-bold text-gray-800 flex items-center justify-center gap-2 text-center">
          <Users className="h-8 w-8 text-vazoOrange" aria-hidden="true" /> Key Benefits
        </h2>
        <ul className="list-disc list-inside text-gray-700 space-y-2 max-w-2xl mx-auto">
          <li>Career Guidance and Planning</li>
          <li>Leadership and Communication Skills</li>
          <li>Networking Strategies</li>
          <li>Personal Branding and Professional Etiquette</li>
          <li>Problem-Solving and Critical Thinking</li>
          <li>Building Resilience and Self-Confidence</li>
        </ul>
        <div className="grid grid-cols-1 sm:grid-cols-2 gap-4 mt-6 max-w-4xl mx-auto">
          <Image
            src="/placeholder.svg?height=200&width=300"
            width={300}
            height={200}
            alt="Mentors and mentees in a group discussion"
            className="rounded-lg object-cover w-full"
            loading="lazy"
          />
          <Image
            src="/placeholder.svg?height=200&width=300"
            width={300}
            height={200}
            alt="One-on-one mentoring session"
            className="rounded-lg object-cover w-full"
            loading="lazy"
          />
        </div>
        <div className="text-center mt-8">
          <Button asChild variant="outline" className="border-vazoOrange text-vazoOrange hover:bg-vazoOrange/10">
            <Link href="/get-involved/volunteer">Become a Mentor</Link>
          </Button>
        </div>
      </section>
    </div>
  )
}
