import { Button } from "@/components/ui/button"
import Link from "next/link"
import { GraduationCap, Users, Briefcase, Shield, Target, Heart, Construction } from "lucide-react"

export default function ProgramsPage() {
  return (
    <div className="container mx-auto px-4 py-8 md:py-16">
      <h1 className="text-4xl font-bold mb-6 text-center text-vazoOrange">Our Programs</h1>
      <p className="text-lg text-gray-700 text-center max-w-3xl mx-auto mb-8">
        At VAZO FOUNDATION NPC, we offer a comprehensive range of programs designed to build a child-safe community
        while equipping young people with the skills, knowledge, and support they need to thrive. Click on a program to
        learn more!
      </p>

      <div className="grid grid-cols-1 lg:grid-cols-2 xl:grid-cols-3 gap-8">
        {/* Skills Workshops Overview */}
        <section className="space-y-4 bg-gray-50 dark:bg-gray-800 p-6 rounded-lg shadow-md">
          <h2 className="text-2xl font-bold text-gray-800 flex items-center justify-center gap-2 text-center">
            <GraduationCap className="h-7 w-7 text-vazoOrange" aria-hidden="true" /> Skills Workshops
          </h2>
          <p className="text-gray-700 text-center">
            Weekly coding and digital-literacy bootcamps providing hands-on training in in-demand technical skills.
          </p>
          <div className="text-center">
            <Button asChild className="bg-vazoOrange hover:bg-vazoOrange/90 text-white mt-4">
              <Link href="/programs/skills-workshops">Learn More</Link>
            </Button>
          </div>
        </section>

        {/* Mentorship Circles Overview */}
        <section className="space-y-4 bg-white dark:bg-gray-950 p-6 rounded-lg shadow-md">
          <h2 className="text-2xl font-bold text-gray-800 flex items-center justify-center gap-2 text-center">
            <Users className="h-7 w-7 text-vazoOrange" aria-hidden="true" /> Mentorship Circles
          </h2>
          <p className="text-gray-700 text-center">
            Monthly group coaching sessions connecting young people with experienced industry experts for guidance.
          </p>
          <div className="text-center">
            <Button asChild className="bg-vazoOrange hover:bg-vazoOrange/90 text-white mt-4">
              <Link href="/programs/mentorship-circles">Learn More</Link>
            </Button>
          </div>
        </section>

        {/* Job-Readiness Coaching Overview */}
        <section className="space-y-4 bg-gray-50 dark:bg-gray-800 p-6 rounded-lg shadow-md">
          <h2 className="text-2xl font-bold text-gray-800 flex items-center justify-center gap-2 text-center">
            <Briefcase className="h-7 w-7 text-vazoOrange" aria-hidden="true" /> Job-Readiness Coaching
          </h2>
          <p className="text-gray-700 text-center">
            Comprehensive support for CV building, interview preparation, and direct job placement assistance.
          </p>
          <div className="text-center">
            <Button asChild className="bg-vazoOrange hover:bg-vazoOrange/90 text-white mt-4">
              <Link href="/programs/job-readiness-coaching">Learn More</Link>
            </Button>
          </div>
        </section>

        {/* Vigilant Program Overview */}
        <section className="space-y-4 bg-white dark:bg-gray-950 p-6 rounded-lg shadow-md relative">
          <div className="absolute top-2 right-2">
            <Construction className="h-5 w-5 text-yellow-500" />
          </div>
          <h2 className="text-2xl font-bold text-gray-800 flex items-center justify-center gap-2 text-center">
            <Shield className="h-7 w-7 text-vazoOrange" aria-hidden="true" /> Vigilant Program
          </h2>
          <p className="text-gray-700 text-center">
            Community safety enablement and child-based violence reporting through innovative technology solutions.
          </p>
          <p className="text-sm text-yellow-600 text-center font-medium">Under Development</p>
          <div className="text-center">
            <Button asChild className="bg-vazoOrange hover:bg-vazoOrange/90 text-white mt-4">
              <Link href="/programs/vigilant">Learn More</Link>
            </Button>
          </div>
        </section>

        {/* Vazo Link Program Overview */}
        <section className="space-y-4 bg-gray-50 dark:bg-gray-800 p-6 rounded-lg shadow-md relative">
          <div className="absolute top-2 right-2">
            <Construction className="h-5 w-5 text-orange-500" />
          </div>
          <h2 className="text-2xl font-bold text-gray-800 flex items-center justify-center gap-2 text-center">
            <Target className="h-7 w-7 text-vazoOrange" aria-hidden="true" /> Vazo Link Program
          </h2>
          <p className="text-gray-700 text-center">
            Opportunity matching platform connecting youth to mentors, services, gigs, and internships.
          </p>
          <p className="text-sm text-orange-600 text-center font-medium">Under Construction</p>
          <div className="text-center">
            <Button asChild className="bg-vazoOrange hover:bg-vazoOrange/90 text-white mt-4">
              <Link href="/programs/vazo-link">Learn More</Link>
            </Button>
          </div>
        </section>

        {/* Health & Wellness Programs Overview */}
        <section className="space-y-4 bg-white dark:bg-gray-950 p-6 rounded-lg shadow-md">
          <h2 className="text-2xl font-bold text-gray-800 flex items-center justify-center gap-2 text-center">
            <Heart className="h-7 w-7 text-vazoOrange" aria-hidden="true" /> Health & Wellness
          </h2>
          <p className="text-gray-700 text-center">
            Mental health support, sports and recreation programs, and trauma-informed care for holistic wellbeing.
          </p>
          <div className="text-center">
            <Button asChild className="bg-vazoOrange hover:bg-vazoOrange/90 text-white mt-4">
              <Link href="/programs/health-wellness">Learn More</Link>
            </Button>
          </div>
        </section>
      </div>
    </div>
  )
}
