import { Button } from "@/components/ui/button"
import Link from "next/link"
import { GraduationCap } from "lucide-react"
import Image from "next/image"

export default function SkillsWorkshopsPage() {
  return (
    <div className="container mx-auto px-4 py-8 md:py-16">
      <h1 className="text-4xl font-bold mb-6 text-center text-vazoOrange">Skills Workshops</h1>
      <p className="text-lg text-gray-700 text-center max-w-3xl mx-auto mb-8">
        Our weekly coding and digital-literacy bootcamps are designed to provide hands-on training in in-demand
        technical skills. From foundational computer literacy to advanced coding concepts, we empower youth with the
        practical abilities needed for the modern workforce.
      </p>

      <section className="space-y-6">
        <h2 className="text-3xl font-bold text-gray-800 flex items-center justify-center gap-2 text-center">
          <GraduationCap className="h-8 w-8 text-vazoOrange" aria-hidden="true" /> What You'll Learn
        </h2>
        <ul className="list-disc list-inside text-gray-700 space-y-2 max-w-2xl mx-auto">
          <li>Introduction to Digital Tools (Microsoft Office, Google Workspace)</li>
          <li>Basic Web Development (HTML, CSS, JavaScript)</li>
          <li>Data Literacy and Spreadsheet Skills</li>
          <li>Cybersecurity Awareness</li>
          <li>Introduction to Graphic Design Principles</li>
          <li>Digital Marketing Fundamentals</li>
        </ul>
        <div className="grid grid-cols-1 sm:grid-cols-2 gap-4 mt-6 max-w-4xl mx-auto">
          <Image
            src="/placeholder.svg?height=200&width=300"
            width={300}
            height={200}
            alt="Youth participating in a coding workshop"
            className="rounded-lg object-cover w-full"
            loading="lazy"
          />
          <Image
            src="/placeholder.svg?height=200&width=300"
            width={300}
            height={200}
            alt="Students learning digital literacy"
            className="rounded-lg object-cover w-full"
            loading="lazy"
          />
        </div>
        <div className="text-center mt-8">
          <Button asChild className="bg-vazoOrange hover:bg-vazoOrange/90 text-white">
            <Link href="/programs/skills-workshops/apply">Apply for Skills Workshops</Link>
          </Button>
        </div>
      </section>
    </div>
  )
}
