import { Card, CardContent, CardDescription, CardHeader, CardTitle } from "@/components/ui/card"
import { Button } from "@/components/ui/button"
import { Badge } from "@/components/ui/badge"
import { FileText, Phone, Shield, Heart, BookOpen, Users, AlertTriangle, ExternalLink, Clock } from "lucide-react"
import Link from "next/link"

export default function ResourcesPage() {
  return (
    <div className="container mx-auto px-4 py-12">
      <div className="text-center mb-12">
        <h1 className="text-4xl font-bold mb-4">Resources & Support</h1>
        <p className="text-xl text-gray-600 max-w-3xl mx-auto">
          Access important resources, emergency contacts, and support services for our community in Pelican Park, Cape
          Town.
        </p>
      </div>

      {/* Emergency Contacts */}
      <section className="mb-16">
        <div className="bg-red-50 border-l-4 border-red-500 p-6 rounded-lg mb-8">
          <div className="flex items-center mb-4">
            <AlertTriangle className="h-6 w-6 text-red-600 mr-2" />
            <h2 className="text-2xl font-bold text-red-800">Emergency Contacts</h2>
          </div>
          <div className="grid md:grid-cols-2 lg:grid-cols-3 gap-4">
            <Card className="border-red-200">
              <CardHeader className="pb-3">
                <CardTitle className="text-lg text-red-800">Police Emergency</CardTitle>
              </CardHeader>
              <CardContent>
                <p className="text-2xl font-bold text-red-600">10111</p>
                <p className="text-sm text-gray-600">24/7 Emergency Response</p>
              </CardContent>
            </Card>
            <Card className="border-red-200">
              <CardHeader className="pb-3">
                <CardTitle className="text-lg text-red-800">Medical Emergency</CardTitle>
              </CardHeader>
              <CardContent>
                <p className="text-2xl font-bold text-red-600">10177</p>
                <p className="text-sm text-gray-600">Ambulance Services</p>
              </CardContent>
            </Card>
            <Card className="border-red-200">
              <CardHeader className="pb-3">
                <CardTitle className="text-lg text-red-800">Fire Department</CardTitle>
              </CardHeader>
              <CardContent>
                <p className="text-2xl font-bold text-red-600">021 480 7700</p>
                <p className="text-sm text-gray-600">Fire & Rescue Services</p>
              </CardContent>
            </Card>
          </div>
        </div>
      </section>

      {/* Child Protection Resources */}
      <section className="mb-16">
        <div className="flex items-center mb-8">
          <Shield className="h-8 w-8 text-blue-600 mr-3" />
          <h2 className="text-3xl font-bold text-gray-800">Child Protection Resources</h2>
        </div>
        <div className="grid md:grid-cols-2 gap-6">
          <Card className="border-blue-200 hover:shadow-lg transition-shadow">
            <CardHeader>
              <CardTitle className="text-blue-800">Childline South Africa</CardTitle>
              <CardDescription>24/7 counselling and support for children</CardDescription>
            </CardHeader>
            <CardContent>
              <div className="space-y-3">
                <div className="flex items-center">
                  <Phone className="h-4 w-4 text-blue-600 mr-2" />
                  <span className="font-semibold">116</span>
                  <Badge variant="secondary" className="ml-2">
                    Free
                  </Badge>
                </div>
                <p className="text-sm text-gray-600">
                  Free counselling service for children and teens in crisis. Available 24/7 in multiple languages.
                </p>
                <Button asChild variant="outline" size="sm">
                  <Link href="https://www.childlinesa.org.za" target="_blank">
                    Visit Website <ExternalLink className="ml-2 h-4 w-4" />
                  </Link>
                </Button>
              </div>
            </CardContent>
          </Card>

          <Card className="border-blue-200 hover:shadow-lg transition-shadow">
            <CardHeader>
              <CardTitle className="text-blue-800">Department of Social Development</CardTitle>
              <CardDescription>Child protection services and support</CardDescription>
            </CardHeader>
            <CardContent>
              <div className="space-y-3">
                <div className="flex items-center">
                  <Phone className="h-4 w-4 text-blue-600 mr-2" />
                  <span className="font-semibold">021 483 4200</span>
                </div>
                <p className="text-sm text-gray-600">
                  Report child abuse, access social services, and get support for families in need.
                </p>
                <Button asChild variant="outline" size="sm">
                  <Link href="/report-incident">
                    Report Incident <AlertTriangle className="ml-2 h-4 w-4" />
                  </Link>
                </Button>
              </div>
            </CardContent>
          </Card>
        </div>
      </section>

      {/* Mental Health Support */}
      <section className="mb-16">
        <div className="flex items-center mb-8">
          <Heart className="h-8 w-8 text-green-600 mr-3" />
          <h2 className="text-3xl font-bold text-gray-800">Mental Health Support</h2>
        </div>
        <div className="grid md:grid-cols-2 lg:grid-cols-3 gap-6">
          <Card className="border-green-200 hover:shadow-lg transition-shadow">
            <CardHeader>
              <CardTitle className="text-green-800">SADAG</CardTitle>
              <CardDescription>South African Depression and Anxiety Group</CardDescription>
            </CardHeader>
            <CardContent>
              <div className="space-y-2">
                <div className="flex items-center">
                  <Phone className="h-4 w-4 text-green-600 mr-2" />
                  <span className="font-semibold">0800 567 567</span>
                </div>
                <div className="flex items-center">
                  <Clock className="h-4 w-4 text-green-600 mr-2" />
                  <span className="text-sm">8am - 8pm Daily</span>
                </div>
              </div>
            </CardContent>
          </Card>

          <Card className="border-green-200 hover:shadow-lg transition-shadow">
            <CardHeader>
              <CardTitle className="text-green-800">Lifeline</CardTitle>
              <CardDescription>Crisis counselling and suicide prevention</CardDescription>
            </CardHeader>
            <CardContent>
              <div className="space-y-2">
                <div className="flex items-center">
                  <Phone className="h-4 w-4 text-green-600 mr-2" />
                  <span className="font-semibold">0861 322 322</span>
                </div>
                <div className="flex items-center">
                  <Clock className="h-4 w-4 text-green-600 mr-2" />
                  <span className="text-sm">24/7 Available</span>
                </div>
              </div>
            </CardContent>
          </Card>

          <Card className="border-green-200 hover:shadow-lg transition-shadow">
            <CardHeader>
              <CardTitle className="text-green-800">VAZO Wellness</CardTitle>
              <CardDescription>Our mental health program</CardDescription>
            </CardHeader>
            <CardContent>
              <div className="space-y-2">
                <Button asChild variant="outline" size="sm" className="w-full bg-transparent">
                  <Link href="/programs/health-wellness">
                    Learn More <ExternalLink className="ml-2 h-4 w-4" />
                  </Link>
                </Button>
              </div>
            </CardContent>
          </Card>
        </div>
      </section>

      {/* Educational Resources */}
      <section className="mb-16">
        <div className="flex items-center mb-8">
          <BookOpen className="h-8 w-8 text-purple-600 mr-3" />
          <h2 className="text-3xl font-bold text-gray-800">Educational Resources</h2>
        </div>
        <div className="grid md:grid-cols-2 gap-6">
          <Card className="border-purple-200 hover:shadow-lg transition-shadow">
            <CardHeader>
              <CardTitle className="text-purple-800">Skills Development</CardTitle>
              <CardDescription>Training and workshop opportunities</CardDescription>
            </CardHeader>
            <CardContent>
              <div className="space-y-3">
                <p className="text-sm text-gray-600">
                  Access our skills workshops, job readiness coaching, and mentorship programs.
                </p>
                <div className="flex gap-2">
                  <Button asChild variant="outline" size="sm">
                    <Link href="/programs/skills-workshops">Skills Workshops</Link>
                  </Button>
                  <Button asChild variant="outline" size="sm">
                    <Link href="/programs/job-readiness-coaching">Job Coaching</Link>
                  </Button>
                </div>
              </div>
            </CardContent>
          </Card>

          <Card className="border-purple-200 hover:shadow-lg transition-shadow">
            <CardHeader>
              <CardTitle className="text-purple-800">Digital Literacy</CardTitle>
              <CardDescription>Computer and internet skills training</CardDescription>
            </CardHeader>
            <CardContent>
              <div className="space-y-3">
                <p className="text-sm text-gray-600">
                  Learn essential digital skills for education and employment opportunities.
                </p>
                <Button asChild variant="outline" size="sm">
                  <Link href="/programs">View Programs</Link>
                </Button>
              </div>
            </CardContent>
          </Card>
        </div>
      </section>

      {/* Community Resources */}
      <section className="mb-16">
        <div className="flex items-center mb-8">
          <Users className="h-8 w-8 text-orange-600 mr-3" />
          <h2 className="text-3xl font-bold text-gray-800">Community Resources</h2>
        </div>
        <div className="grid md:grid-cols-2 lg:grid-cols-3 gap-6">
          <Card className="border-orange-200 hover:shadow-lg transition-shadow">
            <CardHeader>
              <CardTitle className="text-orange-800">Parent Support</CardTitle>
              <CardDescription>Resources and guidance for parents</CardDescription>
            </CardHeader>
            <CardContent>
              <Button asChild className="w-full bg-orange-600 hover:bg-orange-700">
                <Link href="/parent-support">
                  Access Support <Heart className="ml-2 h-4 w-4" />
                </Link>
              </Button>
            </CardContent>
          </Card>

          <Card className="border-orange-200 hover:shadow-lg transition-shadow">
            <CardHeader>
              <CardTitle className="text-orange-800">Volunteer Opportunities</CardTitle>
              <CardDescription>Join our community initiatives</CardDescription>
            </CardHeader>
            <CardContent>
              <Button asChild variant="outline" className="w-full bg-transparent">
                <Link href="/get-involved/volunteer">
                  Get Involved <Users className="ml-2 h-4 w-4" />
                </Link>
              </Button>
            </CardContent>
          </Card>

          <Card className="border-orange-200 hover:shadow-lg transition-shadow">
            <CardHeader>
              <CardTitle className="text-orange-800">Partnership Opportunities</CardTitle>
              <CardDescription>Collaborate with VAZO Foundation</CardDescription>
            </CardHeader>
            <CardContent>
              <Button asChild variant="outline" className="w-full bg-transparent">
                <Link href="/get-involved/partner">
                  Partner With Us <ExternalLink className="ml-2 h-4 w-4" />
                </Link>
              </Button>
            </CardContent>
          </Card>
        </div>
      </section>

      {/* Important Documents */}
      <section>
        <div className="flex items-center mb-8">
          <FileText className="h-8 w-8 text-gray-600 mr-3" />
          <h2 className="text-3xl font-bold text-gray-800">Important Documents</h2>
        </div>
        <div className="grid md:grid-cols-2 gap-6">
          <Card className="border-gray-200 hover:shadow-lg transition-shadow">
            <CardHeader>
              <CardTitle className="text-gray-800">Policies & Procedures</CardTitle>
              <CardDescription>Our organizational policies and guidelines</CardDescription>
            </CardHeader>
            <CardContent>
              <div className="space-y-2">
                <Button asChild variant="outline" size="sm" className="w-full justify-start bg-transparent">
                  <Link href="/about/child-protection">
                    <Shield className="mr-2 h-4 w-4" />
                    Child Protection Policy
                  </Link>
                </Button>
                <Button asChild variant="outline" size="sm" className="w-full justify-start bg-transparent">
                  <Link href="/privacy-policy">
                    <FileText className="mr-2 h-4 w-4" />
                    Privacy Policy
                  </Link>
                </Button>
                <Button asChild variant="outline" size="sm" className="w-full justify-start bg-transparent">
                  <Link href="/whistleblowing-policy">
                    <AlertTriangle className="mr-2 h-4 w-4" />
                    Whistleblowing Policy
                  </Link>
                </Button>
              </div>
            </CardContent>
          </Card>

          <Card className="border-gray-200 hover:shadow-lg transition-shadow">
            <CardHeader>
              <CardTitle className="text-gray-800">Contact Information</CardTitle>
              <CardDescription>Get in touch with our team</CardDescription>
            </CardHeader>
            <CardContent>
              <div className="space-y-3">
                <div>
                  <p className="font-semibold">VAZO Foundation NPC</p>
                  <p className="text-sm text-gray-600">Registration No: 2025 / 634473 / 08</p>
                </div>
                <div>
                  <p className="text-sm">
                    <strong>Location:</strong> Pelican Park, Cape Town
                  </p>
                  <p className="text-sm">
                    <strong>Email:</strong> info@vazofoundations.org
                  </p>
                  <p className="text-sm">
                    <strong>Phone:</strong> +27 87 822 2496
                  </p>
                </div>
              </div>
            </CardContent>
          </Card>
        </div>
      </section>
    </div>
  )
}
