import { Button } from "@/components/ui/button"
import { Card, CardContent, CardHeader, CardTitle } from "@/components/ui/card"
import { Badge } from "@/components/ui/badge"
import { Construction, ArrowLeft, Mail, Phone, Clock } from "lucide-react"
import Link from "next/link"

export default function UnderMaintenancePage() {
  return (
    <div className="min-h-screen bg-gray-50">
      {/* Hero Section */}
      <section className="bg-gradient-to-br from-orange-500 via-orange-600 to-red-600 text-white py-20">
        <div className="container mx-auto px-4">
          <div className="max-w-4xl mx-auto text-center">
            <div className="flex justify-center mb-6">
              <div className="bg-white/10 rounded-full p-6">
                <Construction className="h-20 w-20 text-yellow-300" />
              </div>
            </div>
            <Badge className="mb-6 bg-white/20 text-white border-white/30 hover:bg-white/30">Temporary Notice</Badge>
            <h1 className="text-4xl md:text-5xl font-bold mb-6">Page Under Maintenance</h1>
            <p className="text-xl text-orange-100 max-w-3xl mx-auto mb-8">
              We're currently working on improving this page to serve you better. Please check back soon or contact us
              directly for assistance.
            </p>
            <div className="flex flex-col sm:flex-row gap-4 justify-center">
              <Button asChild size="lg" className="bg-white text-orange-600 hover:bg-gray-100">
                <Link href="/">
                  <ArrowLeft className="mr-2 h-5 w-5" />
                  Return Home
                </Link>
              </Button>
              <Button
                asChild
                size="lg"
                variant="outline"
                className="border-white text-white hover:bg-white hover:text-orange-600 bg-transparent"
              >
                <a href="mailto:info@vazofoundations.org">
                  <Mail className="mr-2 h-5 w-5" />
                  Contact Us
                </a>
              </Button>
            </div>
          </div>
        </div>
      </section>

      {/* Information Section */}
      <section className="py-16">
        <div className="container mx-auto px-4">
          <div className="max-w-4xl mx-auto">
            <div className="grid md:grid-cols-2 gap-8">
              {/* What's Happening */}
              <Card className="border-t-4 border-t-orange-500">
                <CardHeader>
                  <div className="flex items-center mb-4">
                    <div className="bg-orange-100 rounded-full p-3 mr-4">
                      <Construction className="h-6 w-6 text-orange-600" />
                    </div>
                    <CardTitle className="text-2xl text-orange-800">What's Happening?</CardTitle>
                  </div>
                </CardHeader>
                <CardContent>
                  <p className="text-gray-700 mb-4">
                    We're currently updating this page to provide you with better content and improved functionality.
                    Our team is working hard to ensure the best possible experience for our community.
                  </p>
                  <div className="bg-orange-50 p-4 rounded-lg">
                    <div className="flex items-center text-orange-700">
                      <Clock className="h-5 w-5 mr-2" />
                      <span className="font-semibold">Expected completion: Soon</span>
                    </div>
                  </div>
                </CardContent>
              </Card>

              {/* Need Help Now? */}
              <Card className="border-t-4 border-t-blue-500">
                <CardHeader>
                  <div className="flex items-center mb-4">
                    <div className="bg-blue-100 rounded-full p-3 mr-4">
                      <Phone className="h-6 w-6 text-blue-600" />
                    </div>
                    <CardTitle className="text-2xl text-blue-800">Need Help Now?</CardTitle>
                  </div>
                </CardHeader>
                <CardContent>
                  <p className="text-gray-700 mb-6">
                    Don't let maintenance stop you from getting the support you need. Our team is still available to
                    assist you.
                  </p>
                  <div className="space-y-4">
                    <div className="flex items-center p-3 bg-blue-50 rounded-lg">
                      <Phone className="h-5 w-5 text-blue-600 mr-3" />
                      <div>
                        <p className="font-semibold text-blue-800">Call Us</p>
                        <a href="tel:0878222686" className="text-blue-600 hover:underline">
                          087 822 2686
                        </a>
                      </div>
                    </div>
                    <div className="flex items-center p-3 bg-green-50 rounded-lg">
                      <Mail className="h-5 w-5 text-green-600 mr-3" />
                      <div>
                        <p className="font-semibold text-green-800">Email Us</p>
                        <a href="mailto:info@vazofoundations.org" className="text-green-600 hover:underline">
                          info@vazofoundations.org
                        </a>
                      </div>
                    </div>
                  </div>
                </CardContent>
              </Card>
            </div>

            {/* Alternative Pages */}
            <Card className="mt-8 bg-gradient-to-r from-blue-50 to-indigo-50 border-t-4 border-t-indigo-500">
              <CardHeader>
                <CardTitle className="text-2xl text-indigo-800 text-center">
                  Explore Other Areas of Our Website
                </CardTitle>
              </CardHeader>
              <CardContent>
                <div className="grid md:grid-cols-3 gap-6">
                  <div className="text-center">
                    <h4 className="font-semibold text-indigo-800 mb-2">Our Programs</h4>
                    <p className="text-gray-600 text-sm mb-4">
                      Learn about our community programs and how to get involved.
                    </p>
                    <Button
                      asChild
                      variant="outline"
                      className="border-indigo-500 text-indigo-600 hover:bg-indigo-50 bg-transparent"
                    >
                      <Link href="/programs">View Programs</Link>
                    </Button>
                  </div>
                  <div className="text-center">
                    <h4 className="font-semibold text-indigo-800 mb-2">Get Involved</h4>
                    <p className="text-gray-600 text-sm mb-4">
                      Discover ways to volunteer, donate, or partner with us.
                    </p>
                    <Button
                      asChild
                      variant="outline"
                      className="border-indigo-500 text-indigo-600 hover:bg-indigo-50 bg-transparent"
                    >
                      <Link href="/get-involved">Get Involved</Link>
                    </Button>
                  </div>
                  <div className="text-center">
                    <h4 className="font-semibold text-indigo-800 mb-2">About Us</h4>
                    <p className="text-gray-600 text-sm mb-4">Learn more about our mission, values, and team.</p>
                    <Button
                      asChild
                      variant="outline"
                      className="border-indigo-500 text-indigo-600 hover:bg-indigo-50 bg-transparent"
                    >
                      <Link href="/about">About Us</Link>
                    </Button>
                  </div>
                </div>
              </CardContent>
            </Card>

            {/* Thank You Message */}
            <div className="text-center mt-12 p-8 bg-white rounded-lg shadow-sm">
              <h3 className="text-2xl font-bold text-gray-800 mb-4">Thank You for Your Patience</h3>
              <p className="text-gray-600 max-w-2xl mx-auto">
                We appreciate your understanding as we work to improve our services. Your continued support helps us
                build stronger, safer communities across South Africa.
              </p>
            </div>
          </div>
        </div>
      </section>
    </div>
  )
}
