import { Button } from "@/components/ui/button"
import { Card, CardContent, CardHeader, CardTitle } from "@/components/ui/card"
import { Badge } from "@/components/ui/badge"
import {
  Shield,
  Phone,
  Mail,
  AlertTriangle,
  Eye,
  Lock,
  Users,
  FileText,
  Clock,
  CheckCircle,
  MessageSquare,
  UserCheck,
} from "lucide-react"
import Link from "next/link"

export default function WhistleblowingPolicyPage() {
  return (
    <div className="min-h-screen bg-gray-50">
      {/* Hero Section */}
      <section className="bg-gradient-to-br from-blue-600 via-blue-700 to-indigo-800 text-white py-16">
        <div className="container mx-auto px-4">
          <div className="max-w-4xl mx-auto text-center">
            <div className="flex justify-center mb-6">
              <div className="bg-white/10 rounded-full p-4">
                <Shield className="h-16 w-16 text-yellow-300" />
              </div>
            </div>
            <Badge className="mb-6 bg-white/20 text-white border-white/30 hover:bg-white/30">
              Transparency & Accountability
            </Badge>
            <h1 className="text-4xl md:text-5xl font-bold mb-6">Whistleblowing Policy</h1>
            <p className="text-xl text-blue-100 max-w-3xl mx-auto">
              We are committed to the highest standards of integrity, transparency, and accountability. This policy
              provides a safe way to report suspected wrongdoing without fear of retaliation.
            </p>
          </div>
        </div>
      </section>

      {/* Emergency Reporting Section */}
      <section className="py-8 bg-red-50 border-b-4 border-red-500">
        <div className="container mx-auto px-4">
          <div className="max-w-4xl mx-auto">
            <div className="flex items-center justify-center mb-6">
              <AlertTriangle className="h-8 w-8 text-red-600 mr-3" />
              <h2 className="text-2xl font-bold text-red-700">Urgent Concerns - Report Immediately</h2>
            </div>
            <div className="grid md:grid-cols-3 gap-6">
              <Card className="border-red-200 bg-white">
                <CardHeader className="text-center">
                  <Phone className="h-8 w-8 mx-auto mb-2 text-red-600" />
                  <CardTitle className="text-red-700">Call Directly</CardTitle>
                </CardHeader>
                <CardContent className="text-center">
                  <Button asChild className="bg-red-600 hover:bg-red-700 text-white w-full">
                    <a href="tel:0878222686">087 822 2686</a>
                  </Button>
                </CardContent>
              </Card>

              <Card className="border-red-200 bg-white">
                <CardHeader className="text-center">
                  <Mail className="h-8 w-8 mx-auto mb-2 text-red-600" />
                  <CardTitle className="text-red-700">Email Confidentially</CardTitle>
                </CardHeader>
                <CardContent className="text-center">
                  <Button
                    asChild
                    variant="outline"
                    className="border-red-600 text-red-600 hover:bg-red-50 w-full bg-transparent"
                  >
                    <a href="mailto:whistleblowing@vazofoundations.org">Send Email</a>
                  </Button>
                </CardContent>
              </Card>

              <Card className="border-red-200 bg-white">
                <CardHeader className="text-center">
                  <FileText className="h-8 w-8 mx-auto mb-2 text-red-600" />
                  <CardTitle className="text-red-700">Anonymous Report</CardTitle>
                </CardHeader>
                <CardContent className="text-center">
                  <Button
                    asChild
                    variant="outline"
                    className="border-red-600 text-red-600 hover:bg-red-50 w-full bg-transparent"
                  >
                    <Link href="/report-incident">Submit Report</Link>
                  </Button>
                </CardContent>
              </Card>
            </div>
          </div>
        </div>
      </section>

      {/* Main Content */}
      <section className="py-16">
        <div className="container mx-auto px-4">
          <div className="max-w-4xl mx-auto">
            {/* Purpose Section */}
            <Card className="mb-8 border-t-4 border-t-blue-500">
              <CardHeader>
                <div className="flex items-center mb-4">
                  <div className="bg-blue-100 rounded-full p-3 mr-4">
                    <Eye className="h-6 w-6 text-blue-600" />
                  </div>
                  <CardTitle className="text-2xl text-blue-800">1. Purpose</CardTitle>
                </div>
              </CardHeader>
              <CardContent>
                <p className="text-gray-700 leading-relaxed">
                  We are committed to the highest standards of integrity, transparency, and accountability in all our
                  activities. This Whistleblowing Policy provides a safe, confidential, and transparent way for
                  employees, contractors, stakeholders, and members of the public to report suspected wrongdoing,
                  unethical conduct, or regulatory breaches without fear of retaliation.
                </p>
              </CardContent>
            </Card>

            {/* Scope Section */}
            <Card className="mb-8 border-t-4 border-t-green-500">
              <CardHeader>
                <div className="flex items-center mb-4">
                  <div className="bg-green-100 rounded-full p-3 mr-4">
                    <Users className="h-6 w-6 text-green-600" />
                  </div>
                  <CardTitle className="text-2xl text-green-800">2. Scope</CardTitle>
                </div>
              </CardHeader>
              <CardContent>
                <p className="text-gray-700 mb-4">
                  This policy applies to all employees, officers, contractors, suppliers, service providers, and any
                  person who interacts with our organisation. It covers:
                </p>
                <div className="grid md:grid-cols-2 gap-4">
                  <ul className="space-y-2 text-gray-700">
                    <li className="flex items-start">
                      <CheckCircle className="h-5 w-5 text-green-500 mr-2 mt-0.5 flex-shrink-0" />
                      <span>Fraud, corruption, or theft</span>
                    </li>
                    <li className="flex items-start">
                      <CheckCircle className="h-5 w-5 text-green-500 mr-2 mt-0.5 flex-shrink-0" />
                      <span>
                        Breach of laws or regulations (including POPIA, PAIA, and other compliance obligations)
                      </span>
                    </li>
                    <li className="flex items-start">
                      <CheckCircle className="h-5 w-5 text-green-500 mr-2 mt-0.5 flex-shrink-0" />
                      <span>Harassment, discrimination, or abuse</span>
                    </li>
                  </ul>
                  <ul className="space-y-2 text-gray-700">
                    <li className="flex items-start">
                      <CheckCircle className="h-5 w-5 text-green-500 mr-2 mt-0.5 flex-shrink-0" />
                      <span>Gross misconduct or unsafe practices</span>
                    </li>
                    <li className="flex items-start">
                      <CheckCircle className="h-5 w-5 text-green-500 mr-2 mt-0.5 flex-shrink-0" />
                      <span>
                        Any other activity that undermines our ethos of fairness, accountability, and community trust
                      </span>
                    </li>
                  </ul>
                </div>
              </CardContent>
            </Card>

            {/* Principles Section */}
            <Card className="mb-8 border-t-4 border-t-purple-500">
              <CardHeader>
                <div className="flex items-center mb-4">
                  <div className="bg-purple-100 rounded-full p-3 mr-4">
                    <Shield className="h-6 w-6 text-purple-600" />
                  </div>
                  <CardTitle className="text-2xl text-purple-800">3. Principles</CardTitle>
                </div>
              </CardHeader>
              <CardContent>
                <p className="text-gray-700 mb-6">We commit to:</p>
                <div className="grid md:grid-cols-2 gap-6">
                  <div className="space-y-4">
                    <div className="flex items-start">
                      <div className="bg-blue-100 rounded-full p-2 mr-3 mt-1">
                        <Eye className="h-4 w-4 text-blue-600" />
                      </div>
                      <div>
                        <h4 className="font-semibold text-blue-800 mb-1">Transparency</h4>
                        <p className="text-sm text-gray-600">
                          Ensuring that all concerns are handled openly and fairly
                        </p>
                      </div>
                    </div>
                    <div className="flex items-start">
                      <div className="bg-green-100 rounded-full p-2 mr-3 mt-1">
                        <Lock className="h-4 w-4 text-green-600" />
                      </div>
                      <div>
                        <h4 className="font-semibold text-green-800 mb-1">Confidentiality</h4>
                        <p className="text-sm text-gray-600">
                          Protecting the identity of whistleblowers to the fullest extent possible
                        </p>
                      </div>
                    </div>
                    <div className="flex items-start">
                      <div className="bg-red-100 rounded-full p-2 mr-3 mt-1">
                        <Shield className="h-4 w-4 text-red-600" />
                      </div>
                      <div>
                        <h4 className="font-semibold text-red-800 mb-1">Non-retaliation</h4>
                        <p className="text-sm text-gray-600">
                          No person will suffer retaliation for raising a concern in good faith
                        </p>
                      </div>
                    </div>
                  </div>
                  <div className="space-y-4">
                    <div className="flex items-start">
                      <div className="bg-yellow-100 rounded-full p-2 mr-3 mt-1">
                        <UserCheck className="h-4 w-4 text-yellow-600" />
                      </div>
                      <div>
                        <h4 className="font-semibold text-yellow-800 mb-1">Impartiality</h4>
                        <p className="text-sm text-gray-600">Investigations will be handled independently and fairly</p>
                      </div>
                    </div>
                    <div className="flex items-start">
                      <div className="bg-purple-100 rounded-full p-2 mr-3 mt-1">
                        <CheckCircle className="h-4 w-4 text-purple-600" />
                      </div>
                      <div>
                        <h4 className="font-semibold text-purple-800 mb-1">Accountability</h4>
                        <p className="text-sm text-gray-600">
                          Corrective actions will be taken where misconduct or risks are identified
                        </p>
                      </div>
                    </div>
                  </div>
                </div>
              </CardContent>
            </Card>

            {/* Reporting Channels Section */}
            <Card className="mb-8 border-t-4 border-t-orange-500">
              <CardHeader>
                <div className="flex items-center mb-4">
                  <div className="bg-orange-100 rounded-full p-3 mr-4">
                    <MessageSquare className="h-6 w-6 text-orange-600" />
                  </div>
                  <CardTitle className="text-2xl text-orange-800">4. Reporting Channels</CardTitle>
                </div>
              </CardHeader>
              <CardContent>
                <p className="text-gray-700 mb-6">Concerns can be reported through any of the following channels:</p>
                <div className="grid md:grid-cols-2 gap-6">
                  <div className="space-y-4">
                    <div className="bg-blue-50 p-4 rounded-lg">
                      <h4 className="font-semibold text-blue-800 mb-2 flex items-center">
                        <UserCheck className="h-5 w-5 mr-2" />
                        Information Officer
                      </h4>
                      <p className="text-sm text-blue-700 mb-2">Sebastian Hendricks</p>
                      <p className="text-sm text-blue-600">
                        Email:{" "}
                        <a href="mailto:privacy@vazofoundations.org" className="underline">
                          privacy@vazofoundations.org
                        </a>
                      </p>
                    </div>
                    <div className="bg-green-50 p-4 rounded-lg">
                      <h4 className="font-semibold text-green-800 mb-2 flex items-center">
                        <Mail className="h-5 w-5 mr-2" />
                        Confidential Email
                      </h4>
                      <p className="text-sm text-green-600">
                        <a href="mailto:whistleblowing@vazofoundations.org" className="underline">
                          whistleblowing@vazofoundations.org
                        </a>
                      </p>
                    </div>
                  </div>
                  <div className="space-y-4">
                    <div className="bg-purple-50 p-4 rounded-lg">
                      <h4 className="font-semibold text-purple-800 mb-2 flex items-center">
                        <Phone className="h-5 w-5 mr-2" />
                        Direct Phone Line
                      </h4>
                      <p className="text-sm text-purple-600">
                        <a href="tel:0878222686" className="underline">
                          087 822 2686
                        </a>
                      </p>
                    </div>
                    <div className="bg-gray-50 p-4 rounded-lg">
                      <h4 className="font-semibold text-gray-800 mb-2 flex items-center">
                        <FileText className="h-5 w-5 mr-2" />
                        Anonymous Written Submission
                      </h4>
                      <p className="text-sm text-gray-600">
                        Mark envelope "CONFIDENTIAL - Whistleblowing Officer"
                        <br />
                        10a Flamingo Way, Pelican Park, Cape Town
                      </p>
                    </div>
                  </div>
                </div>
              </CardContent>
            </Card>

            {/* Reporting Guidelines Section */}
            <Card className="mb-8 border-t-4 border-t-indigo-500">
              <CardHeader>
                <div className="flex items-center mb-4">
                  <div className="bg-indigo-100 rounded-full p-3 mr-4">
                    <FileText className="h-6 w-6 text-indigo-600" />
                  </div>
                  <CardTitle className="text-2xl text-indigo-800">5. Reporting Guidelines</CardTitle>
                </div>
              </CardHeader>
              <CardContent>
                <p className="text-gray-700 mb-4">
                  When raising a concern, whistleblowers should provide as much detail as possible, including:
                </p>
                <div className="grid md:grid-cols-2 gap-4">
                  <ul className="space-y-2 text-gray-700">
                    <li className="flex items-start">
                      <CheckCircle className="h-5 w-5 text-indigo-500 mr-2 mt-0.5 flex-shrink-0" />
                      <span>The nature of the concern</span>
                    </li>
                    <li className="flex items-start">
                      <CheckCircle className="h-5 w-5 text-indigo-500 mr-2 mt-0.5 flex-shrink-0" />
                      <span>Dates, times, and parties involved</span>
                    </li>
                  </ul>
                  <ul className="space-y-2 text-gray-700">
                    <li className="flex items-start">
                      <CheckCircle className="h-5 w-5 text-indigo-500 mr-2 mt-0.5 flex-shrink-0" />
                      <span>Supporting documents or evidence (if available)</span>
                    </li>
                    <li className="flex items-start">
                      <CheckCircle className="h-5 w-5 text-indigo-500 mr-2 mt-0.5 flex-shrink-0" />
                      <span>Whether the concern has been raised elsewhere</span>
                    </li>
                  </ul>
                </div>
              </CardContent>
            </Card>

            {/* Investigation Process Section */}
            <Card className="mb-8 border-t-4 border-t-teal-500">
              <CardHeader>
                <div className="flex items-center mb-4">
                  <div className="bg-teal-100 rounded-full p-3 mr-4">
                    <Clock className="h-6 w-6 text-teal-600" />
                  </div>
                  <CardTitle className="text-2xl text-teal-800">6. Investigation Process</CardTitle>
                </div>
              </CardHeader>
              <CardContent>
                <div className="space-y-4">
                  <div className="flex items-start">
                    <div className="bg-teal-500 text-white rounded-full w-8 h-8 flex items-center justify-center text-sm font-bold mr-4 mt-1">
                      1
                    </div>
                    <div>
                      <h4 className="font-semibold text-teal-800 mb-1">Acknowledgment</h4>
                      <p className="text-gray-600">All reports will be acknowledged within 5 business days</p>
                    </div>
                  </div>
                  <div className="flex items-start">
                    <div className="bg-teal-500 text-white rounded-full w-8 h-8 flex items-center justify-center text-sm font-bold mr-4 mt-1">
                      2
                    </div>
                    <div>
                      <h4 className="font-semibold text-teal-800 mb-1">Preliminary Review</h4>
                      <p className="text-gray-600">The Whistleblowing Officer will conduct a preliminary review</p>
                    </div>
                  </div>
                  <div className="flex items-start">
                    <div className="bg-teal-500 text-white rounded-full w-8 h-8 flex items-center justify-center text-sm font-bold mr-4 mt-1">
                      3
                    </div>
                    <div>
                      <h4 className="font-semibold text-teal-800 mb-1">Investigation</h4>
                      <p className="text-gray-600">Where necessary, an independent investigator will be appointed</p>
                    </div>
                  </div>
                  <div className="flex items-start">
                    <div className="bg-teal-500 text-white rounded-full w-8 h-8 flex items-center justify-center text-sm font-bold mr-4 mt-1">
                      4
                    </div>
                    <div>
                      <h4 className="font-semibold text-teal-800 mb-1">Documentation & Action</h4>
                      <p className="text-gray-600">Findings will be documented, and corrective action will be taken</p>
                    </div>
                  </div>
                  <div className="flex items-start">
                    <div className="bg-teal-500 text-white rounded-full w-8 h-8 flex items-center justify-center text-sm font-bold mr-4 mt-1">
                      5
                    </div>
                    <div>
                      <h4 className="font-semibold text-teal-800 mb-1">Feedback</h4>
                      <p className="text-gray-600">
                        Whistleblowers (where contact details are available) will be informed of the outcome, subject to
                        confidentiality requirements
                      </p>
                    </div>
                  </div>
                </div>
                <div className="mt-6 p-4 bg-teal-50 rounded-lg">
                  <p className="text-sm text-teal-700">
                    <strong>Timeline Commitment:</strong> We aim to complete all investigations within 30 days of
                    receipt, with complex cases potentially requiring additional time.
                  </p>
                </div>
              </CardContent>
            </Card>

            {/* Protection Section */}
            <Card className="mb-8 border-t-4 border-t-red-500">
              <CardHeader>
                <div className="flex items-center mb-4">
                  <div className="bg-red-100 rounded-full p-3 mr-4">
                    <Shield className="h-6 w-6 text-red-600" />
                  </div>
                  <CardTitle className="text-2xl text-red-800">7. Protection of Whistleblowers</CardTitle>
                </div>
              </CardHeader>
              <CardContent>
                <div className="space-y-4">
                  <div className="bg-red-50 p-4 rounded-lg border-l-4 border-red-500">
                    <h4 className="font-semibold text-red-800 mb-2">Zero Tolerance for Retaliation</h4>
                    <p className="text-red-700 text-sm">
                      Retaliation of any kind against whistleblowers is strictly prohibited. Any employee found to have
                      victimised a whistleblower will face disciplinary action, up to and including dismissal.
                    </p>
                  </div>
                  <div className="bg-yellow-50 p-4 rounded-lg border-l-4 border-yellow-500">
                    <h4 className="font-semibold text-yellow-800 mb-2">Good Faith Requirement</h4>
                    <p className="text-yellow-700 text-sm">
                      Whistleblowers making disclosures in bad faith or with malicious intent may be subject to
                      disciplinary or legal action.
                    </p>
                  </div>
                </div>
              </CardContent>
            </Card>

            {/* Alignment Section */}
            <Card className="mb-8 border-t-4 border-t-blue-500">
              <CardHeader>
                <div className="flex items-center mb-4">
                  <div className="bg-blue-100 rounded-full p-3 mr-4">
                    <Users className="h-6 w-6 text-blue-600" />
                  </div>
                  <CardTitle className="text-2xl text-blue-800">8. Alignment with Our Ethos</CardTitle>
                </div>
              </CardHeader>
              <CardContent>
                <p className="text-gray-700 mb-4">
                  We believe in building a culture of openness, community accountability, and integrity. By encouraging
                  whistleblowing, we:
                </p>
                <div className="grid md:grid-cols-3 gap-4">
                  <div className="text-center p-4 bg-blue-50 rounded-lg">
                    <Shield className="h-8 w-8 text-blue-600 mx-auto mb-2" />
                    <h4 className="font-semibold text-blue-800 mb-1">Protect</h4>
                    <p className="text-sm text-blue-600">Our organisation and stakeholders from harm</p>
                  </div>
                  <div className="text-center p-4 bg-green-50 rounded-lg">
                    <CheckCircle className="h-8 w-8 text-green-600 mx-auto mb-2" />
                    <h4 className="font-semibold text-green-800 mb-1">Promote</h4>
                    <p className="text-sm text-green-600">Ethical behaviour and trust</p>
                  </div>
                  <div className="text-center p-4 bg-purple-50 rounded-lg">
                    <UserCheck className="h-8 w-8 text-purple-600 mx-auto mb-2" />
                    <h4 className="font-semibold text-purple-800 mb-1">Uphold</h4>
                    <p className="text-sm text-purple-600">Our commitment to compliance and fairness</p>
                  </div>
                </div>
              </CardContent>
            </Card>

            {/* Review Section */}
            <Card className="mb-8 border-t-4 border-t-gray-500">
              <CardHeader>
                <div className="flex items-center mb-4">
                  <div className="bg-gray-100 rounded-full p-3 mr-4">
                    <Clock className="h-6 w-6 text-gray-600" />
                  </div>
                  <CardTitle className="text-2xl text-gray-800">9. Review and Communication</CardTitle>
                </div>
              </CardHeader>
              <CardContent>
                <p className="text-gray-700 mb-4">
                  This policy will be reviewed annually to ensure effectiveness and compliance with legal requirements,
                  including the Protected Disclosures Act of South Africa. It will be communicated to all staff and made
                  publicly available to stakeholders.
                </p>
                <div className="bg-gray-50 p-4 rounded-lg">
                  <p className="text-sm text-gray-600">
                    <strong>Last Updated:</strong> January 2024
                    <br />
                    <strong>Next Review:</strong> January 2025
                    <br />
                    <strong>Policy Owner:</strong> Sebastian Hendricks, Information Officer
                  </p>
                </div>
              </CardContent>
            </Card>

            {/* Call to Action */}
            <Card className="bg-gradient-to-r from-blue-600 to-indigo-600 text-white">
              <CardContent className="p-8 text-center">
                <h3 className="text-2xl font-bold mb-4">Have a Concern to Report?</h3>
                <p className="text-blue-100 mb-6">
                  Your voice matters. Help us maintain the highest standards of integrity and accountability.
                </p>
                <div className="flex flex-col sm:flex-row gap-4 justify-center">
                  <Button asChild size="lg" className="bg-white text-blue-600 hover:bg-gray-100">
                    <a href="tel:0878222686">
                      <Phone className="mr-2 h-5 w-5" />
                      Call Now
                    </a>
                  </Button>
                  <Button
                    asChild
                    size="lg"
                    variant="outline"
                    className="border-white text-white hover:bg-white hover:text-blue-600 bg-transparent"
                  >
                    <a href="mailto:whistleblowing@vazofoundations.org">
                      <Mail className="mr-2 h-5 w-5" />
                      Send Email
                    </a>
                  </Button>
                  <Button
                    asChild
                    size="lg"
                    variant="outline"
                    className="border-white text-white hover:bg-white hover:text-blue-600 bg-transparent"
                  >
                    <Link href="/report-incident">
                      <FileText className="mr-2 h-5 w-5" />
                      Anonymous Report
                    </Link>
                  </Button>
                </div>
              </CardContent>
            </Card>
          </div>
        </div>
      </section>
    </div>
  )
}
