-- Create table for partner inquiries
CREATE TABLE IF NOT EXISTS partner_inquiries (
    id SERIAL PRIMARY KEY,
    organization_name TEXT NOT NULL,
    contact_person_name TEXT NOT NULL,
    contact_email TEXT UNIQUE NOT NULL,
    contact_phone TEXT NOT NULL,
    partnership_type TEXT NOT NULL,
    organization_sector TEXT NOT NULL,
    annual_budget_range TEXT NOT NULL,
    primary_partnership_goals TEXT NOT NULL,
    previous_partnership_experience TEXT,
    organization_size TEXT NOT NULL,
    privacy_consent BOOLEAN NOT NULL,
    created_at TIMESTAMP WITH TIME ZONE DEFAULT CURRENT_TIMESTAMP
);

COMMENT ON TABLE partner_inquiries IS 'Stores inquiries from organizations interested in partnering with VAZO Foundation.';
