-- Create table for program applications (Skills Workshops and Job-Readiness Coaching)
CREATE TABLE IF NOT EXISTS program_applications (
    id SERIAL PRIMARY KEY,
    full_name TEXT NOT NULL,
    email TEXT UNIQUE NOT NULL,
    phone TEXT NOT NULL,
    city TEXT NOT NULL,
    program_applying_for TEXT NOT NULL, -- e.g., "Skills Workshops", "Job-Readiness Coaching"
    why_interested TEXT NOT NULL,
    how_did_you_hear JSONB, -- Stores array of strings like ["Social Media", "Friend/Family"]
    educational_background TEXT NOT NULL,
    relevant_skills TEXT NOT NULL,
    past_experience TEXT NOT NULL,
    privacy_consent BOOLEAN NOT NULL,
    created_at TIMESTAMP WITH TIME ZONE DEFAULT CURRENT_TIMESTAMP
);

COMMENT ON TABLE program_applications IS 'Stores applications for various programs like Skills Workshops and Job-Readiness Coaching.';
COMMENT ON COLUMN program_applications.how_did_you_hear IS 'JSON array of how the applicant heard about the program.';
