-- Create table for volunteer applications
CREATE TABLE IF NOT EXISTS volunteer_applications (
    id SERIAL PRIMARY KEY,
    full_name TEXT NOT NULL,
    email TEXT UNIQUE NOT NULL,
    phone TEXT NOT NULL,
    city TEXT NOT NULL,
    available_days JSONB, -- Stores array of strings like ["Weekdays", "Mornings"]
    areas_of_interest JSONB, -- Stores array of strings like ["Mentorship", "Event Support"]
    other_area_of_interest TEXT,
    preferred_commitment TEXT,
    key_skills JSONB, -- Stores array of strings like ["Communication", "Teaching"]
    other_key_skill TEXT,
    past_volunteer_experience TEXT, -- "Yes" or "No"
    past_volunteer_contexts JSONB, -- Stores array of strings like ["Schools", "NGOs"]
    motivation JSONB, -- Stores array of strings like ["Gain Experience", "Give Back"]
    privacy_consent BOOLEAN NOT NULL,
    created_at TIMESTAMP WITH TIME ZONE DEFAULT CURRENT_TIMESTAMP
);

COMMENT ON TABLE volunteer_applications IS 'Stores applications from individuals interested in volunteering.';
COMMENT ON COLUMN volunteer_applications.available_days IS 'JSON array of days and times the volunteer is available.';
COMMENT ON COLUMN volunteer_applications.areas_of_interest IS 'JSON array of preferred volunteer roles.';
COMMENT ON COLUMN volunteer_applications.key_skills IS 'JSON array of key skills and expertise of the volunteer.';
COMMENT ON COLUMN volunteer_applications.past_volunteer_contexts IS 'JSON array of contexts where the volunteer had past experience.';
COMMENT ON COLUMN volunteer_applications.motivation IS 'JSON array of reasons for volunteering.';
